import type { Dictionary } from '@crawlee/types';
import type { Request } from '../request';
import type { IRequestList } from './request_list';
import type { AddRequestsBatchedResult, IRequestManager, RequestQueueOperationInfo, RequestQueueOperationOptions } from './request_provider';
/**
 * Adapts the IRequestList interface to the IRequestManager interface.
 * It simply throws an exception when inserting requests is attempted.
 * @internal
 */
export declare class RequestListAdapter implements IRequestManager {
    private requestList;
    constructor(requestList: IRequestList);
    /**
     * @inheritdoc
     */
    isFinished(): Promise<boolean>;
    /**
     * @inheritdoc
     */
    isEmpty(): Promise<boolean>;
    /**
     * @inheritdoc
     */
    handledCount(): Promise<number>;
    /**
     * @inheritdoc
     */
    getTotalCount(): number;
    /**
     * @inheritdoc
     */
    getPendingCount(): number;
    /**
     * @inheritdoc
     */
    fetchNextRequest<T extends Dictionary = Dictionary>(): Promise<Request<T> | null>;
    /**
     * @inheritdoc
     */
    markRequestHandled(request: Request): Promise<void>;
    /**
     * @inheritdoc
     */
    reclaimRequest(request: Request, _options?: RequestQueueOperationOptions): Promise<RequestQueueOperationInfo | null>;
    /**
     * @inheritdoc
     */
    [Symbol.asyncIterator](): AsyncGenerator<Request<Dictionary>, void, unknown>;
    /**
     * @inheritdoc
     */
    addRequestsBatched(): Promise<AddRequestsBatchedResult>;
    /**
     * @inheritdoc
     */
    addRequest(): Promise<RequestQueueOperationInfo>;
}
//# sourceMappingURL=request_list_adapter.d.ts.map