"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestListAdapter = void 0;
/**
 * Adapts the IRequestList interface to the IRequestManager interface.
 * It simply throws an exception when inserting requests is attempted.
 * @internal
 */
class RequestListAdapter {
    constructor(requestList) {
        Object.defineProperty(this, "requestList", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: requestList
        });
    }
    /**
     * @inheritdoc
     */
    async isFinished() {
        return this.requestList.isFinished();
    }
    /**
     * @inheritdoc
     */
    async isEmpty() {
        return this.requestList.isEmpty();
    }
    /**
     * @inheritdoc
     */
    async handledCount() {
        return Promise.resolve(this.requestList.handledCount());
    }
    /**
     * @inheritdoc
     */
    getTotalCount() {
        return this.requestList.length();
    }
    /**
     * @inheritdoc
     */
    getPendingCount() {
        return this.requestList.length() - this.requestList.handledCount();
    }
    /**
     * @inheritdoc
     */
    async fetchNextRequest() {
        return await this.requestList.fetchNextRequest();
    }
    /**
     * @inheritdoc
     */
    async markRequestHandled(request) {
        return this.requestList.markRequestHandled(request);
    }
    /**
     * @inheritdoc
     */
    async reclaimRequest(request, _options) {
        await this.requestList.reclaimRequest(request);
        return null;
    }
    /**
     * @inheritdoc
     */
    async *[Symbol.asyncIterator]() {
        for await (const request of this.requestList) {
            yield request;
        }
    }
    /**
     * @inheritdoc
     */
    addRequestsBatched() {
        throw new Error('Cannot add requests to a read-only request list');
    }
    /**
     * @inheritdoc
     */
    addRequest() {
        throw new Error('Cannot add requests to a read-only request list');
    }
}
exports.RequestListAdapter = RequestListAdapter;
//# sourceMappingURL=request_list_adapter.js.map