/* auto-generated by NAPI-RS */
/* eslint-disable */
export declare class Curl {
  closed: boolean
  constructor()
  /** 初始化数据回调 */
  init(): void
  setHeadersRaw(headers: Array<string>): void
  setOption(option: CurlOpt, value: string | number | boolean): void
  setBody(value: string | Buffer): void
  setOptStrList(option: CurlOpt, arrays: Array<string>): void
  /** 获取响应码 */
  getInfoNumber(option: CurlInfo): number
  /** 获取字符串信息 */
  getInfoString(option: CurlInfo): string
  /** 模拟浏览器 */
  impersonate(target: string, defaultHeaders?: boolean | undefined | null): void
  /** 获取错误信息字符串 */
  error(code: number): string
  /** 获取curlID */
  id(): string
  /** 清理 curl handle */
  close(): void
  /** 重置 curl */
  reset(): void
  /** 执行 curl 请求 */
  performSync(): void
  performOld(): Promise<void>
  /** 执行 curl 请求（使用 AsyncTask） */
  perform(): Promise<unknown>
  /** 获取响应头数据 */
  getRespHeaders(): Buffer
  /** 获取响应体数据 */
  getRespBody(): Buffer
  /** 获取信息数组 */
  getInfoList(option: CurlInfo): Array<string>
  /** 设置链表 */
  setOptList(option: CurlOpt, arrays: Array<string>): void
  /** 获取cookie列表 */
  getCookies(): Array<string>
  /** 设置 cookie */
  setCookies(cookie: string): void
  status(): number
}

export declare class CurlMulti {
  closed: boolean
  constructor()
  setOption(option: CurlMOpt, value: string | number | boolean): void
  setOptBuffer(option: CurlMOpt, body: Buffer): void
  setSocketCallback(callback: ((err: Error | null, arg: SocketData) => any)): void
  setTimerCallback(callback: ((err: Error | null, arg: TimerData) => any)): void
  addHandle(curl: Curl): number
  removeHandle(curl: Curl): number
  error(err: number): string
  perform(): number
  /** 使用 AsyncTask 的 poll */
  poll(timeoutMs: number): Promise<unknown>
  /** 使用 AsyncTask 的 wait */
  wait(timeoutMs: number): Promise<unknown>
  getRunningHandles(): number
  socketAction(socket: number, what: number): number
  infoRead(): CurlMsgResult | null
  close(): void
}

export declare function curlEasyError(code: number): string

export declare const enum CurlError {
  Ok = 0,
  UnsupportedProtocol = 1,
  FailedInit = 2,
  UrlMalformat = 3,
  NotBuiltIn = 4,
  CouldntResolveProxy = 5,
  CouldntResolveHost = 6,
  CouldntConnect = 7,
  WeirdServerReply = 8,
  RemoteAccessDenied = 9,
  FtpAcceptFailed = 10,
  FtpWeirdPassReply = 11,
  FtpAcceptTimeout = 12,
  FtpWeirdPasvReply = 13,
  FtpWeird227Format = 14,
  FtpCantGetHost = 15,
  Http2 = 16,
  FtpCouldntSetType = 17,
  PartialFile = 18,
  FtpCouldntRetrFile = 19,
  Obsolete20 = 20,
  QuoteError = 21,
  HttpReturnedError = 22,
  WriteError = 23,
  Obsolete24 = 24,
  UploadFailed = 25,
  ReadError = 26,
  OutOfMemory = 27,
  OperationTimedout = 28,
  Obsolete29 = 29,
  FtpPortFailed = 30,
  FtpCouldntUseRest = 31,
  Obsolete32 = 32,
  RangeError = 33,
  Obsolete34 = 34,
  SslConnectError = 35,
  BadDownloadResume = 36,
  FileCouldntReadFile = 37,
  LdapCannotBind = 38,
  LdapSearchFailed = 39,
  Obsolete40 = 40,
  Obsolete41 = 41,
  AbortedByCallback = 42,
  BadFunctionArgument = 43,
  Obsolete44 = 44,
  InterfaceFailed = 45,
  Obsolete46 = 46,
  TooManyRedirects = 47,
  UnknownOption = 48,
  SetoptOptionSyntax = 49,
  Obsolete50 = 50,
  Obsolete51 = 51,
  GotNothing = 52,
  SslEngineNotfound = 53,
  SslEngineSetfailed = 54,
  SendError = 55,
  RecvError = 56,
  Obsolete57 = 57,
  SslCertproblem = 58,
  SslCipher = 59,
  PeerFailedVerification = 60,
  BadContentEncoding = 61,
  Obsolete62 = 62,
  FilesizeExceeded = 63,
  UseSslFailed = 64,
  SendFailRewind = 65,
  SslEngineInitfailed = 66,
  LoginDenied = 67,
  TftpNotfound = 68,
  TftpPerm = 69,
  RemoteDiskFull = 70,
  TftpIllegal = 71,
  TftpUnknownId = 72,
  RemoteFileExists = 73,
  TftpNoSuchUser = 74,
  Obsolete75 = 75,
  Obsolete76 = 76,
  SslCacertBadfile = 77,
  RemoteFileNotFound = 78,
  Ssh = 79,
  SslShutdownFailed = 80,
  Again = 81,
  SslCrlBadfile = 82,
  SslIssuerError = 83,
  FtpPretFailed = 84,
  RtspCSeqError = 85,
  RtspSessionError = 86,
  FtpBadFileList = 87,
  ChunkFailed = 88,
  NoConnectionAvailable = 89,
  SslPinnedpubkeynotmatch = 90,
  SslInvalidcertstatus = 91,
  Http2Stream = 92,
  RecursiveApiCall = 93,
  AuthError = 94,
  Http3 = 95,
  QuicConnectError = 96,
  Proxy = 97,
  SslClientcert = 98,
  UnrecoverablePoll = 99,
  TooLarge = 100,
  EchRequired = 101
}

export declare const enum CurlHttpVersion {
  None = 0,
  V1_0 = 1,
  V1_1 = 2,
  V2_0 = 3,
  V2Tls = 4,
  V2PriorKnowledge = 5,
  V3 = 30,
  V3Only = 31
}

export declare const enum CurlImpersonate {
  Chrome99 = 'Chrome99',
  Chrome100 = 'Chrome100',
  Chrome101 = 'Chrome101',
  Chrome104 = 'Chrome104',
  Chrome107 = 'Chrome107',
  Chrome110 = 'Chrome110',
  Chrome116 = 'Chrome116',
  Chrome119 = 'Chrome119',
  Chrome120 = 'Chrome120',
  Chrome123 = 'Chrome123',
  Chrome124 = 'Chrome124',
  Chrome131 = 'Chrome131',
  Chrome133a = 'Chrome133a',
  Chrome136 = 'Chrome136',
  Chrome99Android = 'Chrome99Android',
  Chrome131Android = 'Chrome131Android',
  Edge99 = 'Edge99',
  Edge101 = 'Edge101',
  Safari153 = 'Safari153',
  Safari155 = 'Safari155',
  Safari170 = 'Safari170',
  Safari172Ios = 'Safari172Ios',
  Safari180 = 'Safari180',
  Safari180Ios = 'Safari180Ios',
  Safari184 = 'Safari184',
  Safari184Ios = 'Safari184Ios',
  Firefox133 = 'Firefox133',
  Firefox135 = 'Firefox135',
  Tor145 = 'Tor145',
  Chrome = 'Chrome',
  Edge = 'Edge',
  Safari = 'Safari'
}

export declare const enum CurlInfo {
  Text = 0,
  EffectiveUrl = 1048577,
  ResponseCode = 2097154,
  TotalTime = 3145731,
  NameLookupTime = 3145732,
  ConnectTime = 3145733,
  PreTransferTime = 3145734,
  SizeUploadT = 6291463,
  SizeDownloadT = 6291464,
  SpeedDownloadT = 6291465,
  SpeedUploadT = 6291466,
  HeaderSize = 2097163,
  RequestSize = 2097164,
  SslVerifyResult = 2097165,
  FileTime = 2097166,
  FileTimeT = 6291470,
  ContentLengthDownloadT = 6291471,
  ContentLengthUploadT = 6291472,
  StartTransferTime = 3145745,
  ContentType = 1048594,
  RedirectTime = 3145747,
  RedirectCount = 2097172,
  Private = 1048597,
  HttpConnectCode = 2097174,
  HttpAuthAvail = 2097175,
  ProxyAuthAvail = 2097176,
  OsErrno = 2097177,
  NumConnects = 2097178,
  SslEngines = 4194331,
  CookieList = 4194332,
  FtpEntryPath = 1048606,
  RedirectUrl = 1048607,
  PrimaryIp = 1048608,
  AppConnectTime = 3145761,
  CertInfo = 4194338,
  ConditionUnmet = 2097187,
  RtspSessionId = 1048612,
  RtspClientCSeq = 2097189,
  RtspServerCSeq = 2097190,
  RtspCSeqRecv = 2097191,
  PrimaryPort = 2097192,
  LocalIp = 1048617,
  LocalPort = 2097194,
  ActiveSocket = 5242924,
  TlsSslPtr = 4194349,
  HttpVersion = 2097198,
  ProxySslVerifyResult = 2097199,
  Scheme = 1048625,
  TotalTimeT = 6291506,
  NameLookupTimeT = 6291507,
  ConnectTimeT = 6291508,
  PreTransferTimeT = 6291509,
  StartTransferTimeT = 6291510,
  RedirectTimeT = 6291511,
  AppConnectTimeT = 6291512,
  RetryAfter = 6291513,
  EffectiveMethod = 1048634,
  ProxyError = 2097211,
  Referer = 1048636,
  CaInfo = 1048637,
  CaPath = 1048638,
  XferId = 6291519,
  ConnId = 6291520,
  QueueTimeT = 6291521,
  UsedProxy = 2097218,
  PostTransferTimeT = 6291523,
  EarlyDataSentT = 6291524,
  HttpAuthUsed = 2097221,
  ProxyAuthUsed = 2097222,
  LastOne = 70
}

export declare const enum CurlIpResolve {
  Whatever = 0,
  V4 = 1,
  V6 = 2
}

export declare const enum CurlMOpt {
  SocketFunction = 20001,
  SocketData = 10002,
  Pipelining = 3,
  TimerFunction = 20004,
  TimerData = 10005,
  MaxConnects = 6,
  MaxHostConnections = 7,
  MaxPipelineLength = 8,
  ContentLengthPenaltySize = 30009,
  ChunkLengthPenaltySize = 30010,
  PipeliningSiteBl = 10011,
  PipeliningServerBl = 10012,
  MaxTotalConnections = 13,
  PushFunction = 20014,
  PushData = 10015,
  MaxConcurrentStreams = 16
}

export interface CurlMsgDataResult {
  whatever: number
  result: number
}

export interface CurlMsgResult {
  msg: number
  easyHandle: number
  easyId: string
  data: CurlMsgDataResult
}

export declare function curlMultiError(code: number): string

export declare const enum CurlOpt {
  WriteData = 10001,
  Url = 10002,
  Port = 3,
  Proxy = 10004,
  UserPwd = 10005,
  ProxyUserPwd = 10006,
  Range = 10007,
  ReadData = 10009,
  ErrorBuffer = 10010,
  WriteFunction = 20011,
  ReadFunction = 20012,
  Timeout = 13,
  InFileSize = 14,
  PostFields = 10015,
  Referer = 10016,
  FtpPort = 10017,
  UserAgent = 10018,
  LowSpeedLimit = 19,
  LowSpeedTime = 20,
  ResumeFrom = 21,
  Cookie = 10022,
  HttpHeader = 10023,
  HttpPost = 10024,
  SslCert = 10025,
  KeyPasswd = 10026,
  Crlf = 27,
  Quote = 10028,
  HeaderData = 10029,
  CookieFile = 10031,
  SslVersion = 32,
  TimeCondition = 33,
  TimeValue = 34,
  CustomRequest = 10036,
  Stderr = 10037,
  PostQuote = 10039,
  Verbose = 41,
  Header = 42,
  NoProgress = 43,
  Nobody = 44,
  FailOnError = 45,
  Upload = 46,
  Post = 47,
  DirListOnly = 48,
  Append = 50,
  Netrc = 51,
  FollowLocation = 52,
  TransferText = 53,
  Put = 54,
  ProgressFunction = 20056,
  XferInfoData = 10057,
  AutoReferer = 58,
  ProxyPort = 59,
  PostFieldSize = 60,
  HttpProxyTunnel = 61,
  Interface = 10062,
  KrbLevel = 10063,
  SslVerifyPeer = 64,
  CaInfo = 10065,
  MaxRedirs = 68,
  FileTime = 69,
  TelnetOptions = 10070,
  MaxConnects = 71,
  FreshConnect = 74,
  ForbidReuse = 75,
  RandomFile = 10076,
  EgdSocket = 10077,
  ConnectTimeout = 78,
  HeaderFunction = 20079,
  HttpGet = 80,
  SslVerifyHost = 81,
  CookieJar = 10082,
  SslCipherList = 10083,
  HttpVersion = 84,
  FtpUseEpsv = 85,
  SslCertType = 10086,
  SslKey = 10087,
  SslKeyType = 10088,
  SslEngine = 10089,
  SslEngineDefault = 90,
  DnsUseGlobalCache = 91,
  DnsCacheTimeout = 92,
  PreQuote = 10093,
  DebugFunction = 20094,
  DebugData = 10095,
  CookieSession = 96,
  CaPath = 10097,
  BufferSize = 98,
  NoSignal = 99,
  Share = 10100,
  ProxyType = 101,
  AcceptEncoding = 10102,
  Private = 10103,
  Http200Aliases = 10104,
  UnrestrictedAuth = 105,
  FtpUseEprt = 106,
  HttpAuth = 107,
  SslCtxFunction = 20108,
  SslCtxData = 10109,
  FtpCreateMissingDirs = 110,
  ProxyAuth = 111,
  ServerResponseTimeout = 112,
  IpResolve = 113,
  MaxFileSize = 114,
  InFileSizeLarge = 30115,
  ResumeFromLarge = 30116,
  MaxFileSizeLarge = 30117,
  NetrcFile = 10118,
  UseSsl = 119,
  PostFieldSizeLarge = 30120,
  TcpNoDelay = 121,
  FtpSslAuth = 129,
  IoctlFunction = 20130,
  IoctlData = 10131,
  FtpAccount = 10134,
  CookieList = 10135,
  IgnoreContentLength = 136,
  FtpSkipPasvIp = 137,
  FtpFileMethod = 138,
  LocalPort = 139,
  LocalPortRange = 140,
  ConnectOnly = 141,
  ConvFromNetworkFunction = 20142,
  ConvToNetworkFunction = 20143,
  ConvFromUtf8Function = 20144,
  MaxSendSpeedLarge = 30145,
  MaxRecvSpeedLarge = 30146,
  FtpAlternativeToUser = 10147,
  SockoptFunction = 20148,
  SockoptData = 10149,
  SslSessionIdCache = 150,
  SshAuthTypes = 151,
  SshPublicKeyFile = 10152,
  SshPrivateKeyFile = 10153,
  FtpSslCcc = 154,
  TimeoutMs = 155,
  ConnectTimeoutMs = 156,
  HttpTransferDecoding = 157,
  HttpContentDecoding = 158,
  NewFilePerms = 159,
  NewDirectoryPerms = 160,
  PostRedir = 161,
  SshHostPublicKeyMd5 = 10162,
  OpenSocketFunction = 20163,
  OpenSocketData = 10164,
  CopyPostFields = 10165,
  ProxyTransferMode = 166,
  SeekFunction = 20167,
  SeekData = 10168,
  CrlFile = 10169,
  IssuerCert = 10170,
  AddressScope = 171,
  CertInfo = 172,
  Username = 10173,
  Password = 10174,
  ProxyUsername = 10175,
  ProxyPassword = 10176,
  NoProxy = 10177,
  TftpBlkSize = 178,
  Socks5GssapiService = 10179,
  Socks5GssapiNec = 180,
  Protocols = 181,
  RedirProtocols = 182,
  SshKnownHosts = 10183,
  SshKeyFunction = 20184,
  SshKeyData = 10185,
  MailFrom = 10186,
  MailRcpt = 10187,
  FtpUsePret = 188,
  RtspRequest = 189,
  RtspSessionId = 10190,
  RtspStreamUri = 10191,
  RtspTransport = 10192,
  RtspClientCSeq = 193,
  RtspServerCSeq = 194,
  InterleaveData = 10195,
  InterleaveFunction = 20196,
  WildcardMatch = 197,
  ChunkBgnFunction = 20198,
  ChunkEndFunction = 20199,
  FnmatchFunction = 20200,
  ChunkData = 10201,
  FnmatchData = 10202,
  Resolve = 10203,
  TlsAuthUsername = 10204,
  TlsAuthPassword = 10205,
  TlsAuthType = 10206,
  TransferEncoding = 207,
  CloseSocketFunction = 20208,
  CloseSocketData = 10209,
  GssapiDelegation = 210,
  DnsServers = 10211,
  AcceptTimeoutMs = 212,
  TcpKeepAlive = 213,
  TcpKeepIdle = 214,
  TcpKeepIntvl = 215,
  SslOptions = 216,
  MailAuth = 10217,
  SaslIr = 218,
  XferInfoFunction = 20219,
  XOAuth2Bearer = 10220,
  DnsInterface = 10221,
  DnsLocalIp4 = 10222,
  DnsLocalIp6 = 10223,
  LoginOptions = 10224,
  SslEnableNpn = 225,
  SslEnableAlpn = 226,
  Expect100TimeoutMs = 227,
  ProxyHeader = 10228,
  HeaderOpt = 229,
  PinnedPublicKey = 10230,
  UnixSocketPath = 10231,
  SslVerifyStatus = 232,
  SslFalseStart = 233,
  PathAsIs = 234,
  ProxyServiceName = 10235,
  ServiceName = 10236,
  PipeWait = 237,
  DefaultProtocol = 10238,
  StreamWeight = 239,
  StreamDepends = 10240,
  StreamDependsE = 10241,
  TftpNoOptions = 242,
  ConnectTo = 10243,
  TcpFastOpen = 244,
  KeepSendingOnError = 245,
  ProxyCaInfo = 10246,
  ProxyCaPath = 10247,
  ProxySslVerifyPeer = 248,
  ProxySslVerifyHost = 249,
  ProxySslVersion = 250,
  ProxyTlsAuthUsername = 10251,
  ProxyTlsAuthPassword = 10252,
  ProxyTlsAuthType = 10253,
  ProxySslCert = 10254,
  ProxySslCertType = 10255,
  ProxySslKey = 10256,
  ProxySslKeyType = 10257,
  ProxyKeyPasswd = 10258,
  ProxySslCipherList = 10259,
  ProxyCrlFile = 10260,
  ProxySslOptions = 261,
  PreProxy = 10262,
  ProxyPinnedPublicKey = 10263,
  AbstractUnixSocket = 10264,
  SuppressConnectHeaders = 265,
  RequestTarget = 10266,
  Socks5Auth = 267,
  SshCompression = 268,
  MimePost = 10269,
  TimeValueLarge = 30270,
  HappyEyeballsTimeoutMs = 271,
  ResolverStartFunction = 20272,
  ResolverStartData = 10273,
  HaProxyProtocol = 274,
  DnsShuffleAddresses = 275,
  Tls13Ciphers = 10276,
  ProxyTls13Ciphers = 10277,
  DisallowUsernameInUrl = 278,
  DohUrl = 10279,
  UploadBufferSize = 280,
  UpkeepIntervalMs = 281,
  CurlU = 10282,
  TrailerFunction = 20283,
  TrailerData = 10284,
  Http09Allowed = 285,
  AltsvcCtrl = 286,
  Altsvc = 10287,
  MaxAgeConn = 288,
  SaslAuthzId = 10289,
  MailRcptAllowFails = 290,
  SslCertBlob = 40291,
  SslKeyBlob = 40292,
  ProxySslCertBlob = 40293,
  ProxySslKeyBlob = 40294,
  IssuerCertBlob = 40295,
  ProxyIssuerCert = 10296,
  ProxyIssuerCertBlob = 40297,
  SslEcCurves = 10298,
  HstsCtrl = 299,
  Hsts = 10300,
  HstsReadFunction = 20301,
  HstsReadData = 10302,
  HstsWriteFunction = 20303,
  HstsWriteData = 10304,
  AwsSigV4 = 10305,
  DohSslVerifyPeer = 306,
  DohSslVerifyHost = 307,
  DohSslVerifyStatus = 308,
  CaInfoBlob = 40309,
  ProxyCaInfoBlob = 40310,
  SshHostPublicKeySha256 = 10311,
  PrereqFunction = 20312,
  PrereqData = 10313,
  MaxLifetimeConn = 314,
  MimeOptions = 315,
  SshHostKeyFunction = 20316,
  SshHostKeyData = 10317,
  ProtocolsStr = 10318,
  RedirProtocolsStr = 10319,
  WsOptions = 320,
  CaCacheTimeout = 321,
  QuickExit = 322,
  HaProxyClientIp = 10323,
  ServerResponseTimeoutMs = 324,
  Ech = 10325,
  TcpKeepCnt = 326,
  UploadFlags = 327,
  HttpBaseHeader = 11000,
  SslSigHashAlgs = 11001,
  SslEnableAlps = 1002,
  SslCertCompression = 11003,
  SslEnableTicket = 1004,
  Http2PseudoHeadersOrder = 11005,
  Http2Settings = 11006,
  SslPermuteExtensions = 1007,
  Http2WindowUpdate = 1008,
  Http2Streams = 11010,
  TlsGrease = 1011,
  TlsExtensionOrder = 11012,
  StreamExclusive = 1013,
  TlsKeyUsageNoCheck = 1014,
  TlsSignedCertTimestamps = 1015,
  TlsStatusRequest = 1016,
  TlsDelegatedCredentials = 11017,
  TlsRecordSizeLimit = 1018,
  TlsKeySharesLimit = 1019,
  TlsUseNewAlpsCodepoint = 1020,
  TlsUseFirefoxTls13Ciphers = 1021
}

export declare const enum CurlSslVersion {
  Default = 0,
  TlsV1 = 1,
  SslV2 = 2,
  SslV3 = 3,
  TlsV1_0 = 4,
  TlsV1_1 = 5,
  TlsV1_2 = 6,
  TlsV1_3 = 7,
  MaxDefault = 65536
}

export declare const enum CurlWsFlag {
  Text = 1,
  Binary = 2,
  Cont = 4,
  Close = 8,
  Ping = 16,
  Offset = 32
}

export declare function getDefaultDirName(): string

export declare function getDefaultLibPath(base?: string | undefined | null): string

export declare function getLibPath(): string | null

/** 获取 libcurl 版本信息 */
export declare function getVersion(): string

/** 全局清理 */
export declare function globalCleanup(): void

/** 全局初始化 */
export declare function globalInit(flags: number): number

export declare function setLibPath(path: string): void

export interface SocketData {
  curlId: string
  sockfd: number
  what: number
}

export declare function socketIsReadable(sockfd: number): boolean

export declare function socketIsWritable(sockfd: number): boolean

export interface TimerData {
  multiId: string
  timeoutMs: number
}
