// prettier-ignore
/* eslint-disable */
// @ts-nocheck
/* auto-generated by NAPI-RS */

const { createRequire } = require('node:module')
require = createRequire(__filename)

const { readFileSync } = require('node:fs')
let nativeBinding = null
const loadErrors = []

const isMusl = () => {
  let musl = false
  if (process.platform === 'linux') {
    musl = isMuslFromFilesystem()
    if (musl === null) {
      musl = isMuslFromReport()
    }
    if (musl === null) {
      musl = isMuslFromChildProcess()
    }
  }
  return musl
}

const isFileMusl = (f) => f.includes('libc.musl-') || f.includes('ld-musl-')

const isMuslFromFilesystem = () => {
  try {
    return readFileSync('/usr/bin/ldd', 'utf-8').includes('musl')
  } catch {
    return null
  }
}

const isMuslFromReport = () => {
  let report = null
  if (typeof process.report?.getReport === 'function') {
    process.report.excludeNetwork = true
    report = process.report.getReport()
  }
  if (!report) {
    return null
  }
  if (report.header && report.header.glibcVersionRuntime) {
    return false
  }
  if (Array.isArray(report.sharedObjects)) {
    if (report.sharedObjects.some(isFileMusl)) {
      return true
    }
  }
  return false
}

const isMuslFromChildProcess = () => {
  try {
    return require('child_process').execSync('ldd --version', { encoding: 'utf8' }).includes('musl')
  } catch (e) {
    // If we reach this case, we don't know if the system is musl or not, so is better to just fallback to false
    return false
  }
}

function requireNative() {
  if (process.env.NAPI_RS_NATIVE_LIBRARY_PATH) {
    try {
      nativeBinding = require(process.env.NAPI_RS_NATIVE_LIBRARY_PATH);
    } catch (err) {
      loadErrors.push(err)
    }
  } else if (process.platform === 'android') {
    if (process.arch === 'arm64') {
      try {
        return require('./libcurl.android-arm64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-android-arm64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm') {
      try {
        return require('./libcurl.android-arm-eabi.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-android-arm-eabi')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on Android ${process.arch}`))
    }
  } else if (process.platform === 'win32') {
    if (process.arch === 'x64') {
      try {
        return require('./libcurl.win32-x64-msvc.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-win32-x64-msvc')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'ia32') {
      try {
        return require('./libcurl.win32-ia32-msvc.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-win32-ia32-msvc')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm64') {
      try {
        return require('./libcurl.win32-arm64-msvc.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-win32-arm64-msvc')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on Windows: ${process.arch}`))
    }
  } else if (process.platform === 'darwin') {
    try {
      return require('./libcurl.darwin-universal.node')
    } catch (e) {
      loadErrors.push(e)
    }
    try {
      return require('@tocha688/libcurl-darwin-universal')
    } catch (e) {
      loadErrors.push(e)
    }
    if (process.arch === 'x64') {
      try {
        return require('./libcurl.darwin-x64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-darwin-x64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm64') {
      try {
        return require('./libcurl.darwin-arm64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-darwin-arm64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on macOS: ${process.arch}`))
    }
  } else if (process.platform === 'freebsd') {
    if (process.arch === 'x64') {
      try {
        return require('./libcurl.freebsd-x64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-freebsd-x64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm64') {
      try {
        return require('./libcurl.freebsd-arm64.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-freebsd-arm64')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on FreeBSD: ${process.arch}`))
    }
  } else if (process.platform === 'linux') {
    if (process.arch === 'x64') {
      if (isMusl()) {
        try {
          return require('./libcurl.linux-x64-musl.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@tocha688/libcurl-linux-x64-musl')
        } catch (e) {
          loadErrors.push(e)
        }
      } else {
        try {
          return require('./libcurl.linux-x64-gnu.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@tocha688/libcurl-linux-x64-gnu')
        } catch (e) {
          loadErrors.push(e)
        }
      }
    } else if (process.arch === 'arm64') {
      if (isMusl()) {
        try {
          return require('./libcurl.linux-arm64-musl.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@tocha688/libcurl-linux-arm64-musl')
        } catch (e) {
          loadErrors.push(e)
        }
      } else {
        try {
          return require('./libcurl.linux-arm64-gnu.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@tocha688/libcurl-linux-arm64-gnu')
        } catch (e) {
          loadErrors.push(e)
        }
      }
    } else if (process.arch === 'arm') {
      if (isMusl()) {
        try {
          return require('./libcurl.linux-arm-musleabihf.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@tocha688/libcurl-linux-arm-musleabihf')
        } catch (e) {
          loadErrors.push(e)
        }
      } else {
        try {
          return require('./libcurl.linux-arm-gnueabihf.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@tocha688/libcurl-linux-arm-gnueabihf')
        } catch (e) {
          loadErrors.push(e)
        }
      }
    } else if (process.arch === 'riscv64') {
      if (isMusl()) {
        try {
          return require('./libcurl.linux-riscv64-musl.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@tocha688/libcurl-linux-riscv64-musl')
        } catch (e) {
          loadErrors.push(e)
        }
      } else {
        try {
          return require('./libcurl.linux-riscv64-gnu.node')
        } catch (e) {
          loadErrors.push(e)
        }
        try {
          return require('@tocha688/libcurl-linux-riscv64-gnu')
        } catch (e) {
          loadErrors.push(e)
        }
      }
    } else if (process.arch === 'ppc64') {
      try {
        return require('./libcurl.linux-ppc64-gnu.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-linux-ppc64-gnu')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 's390x') {
      try {
        return require('./libcurl.linux-s390x-gnu.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-linux-s390x-gnu')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on Linux: ${process.arch}`))
    }
  } else if (process.platform === 'openharmony') {
    if (process.arch === 'arm64') {
      try {
        return require('./libcurl.linux-arm64-ohos.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-linux-arm64-ohos')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'x64') {
      try {
        return require('./libcurl.linux-x64-ohos.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-linux-x64-ohos')
      } catch (e) {
        loadErrors.push(e)
      }
    } else if (process.arch === 'arm') {
      try {
        return require('./libcurl.linux-arm-ohos.node')
      } catch (e) {
        loadErrors.push(e)
      }
      try {
        return require('@tocha688/libcurl-linux-arm-ohos')
      } catch (e) {
        loadErrors.push(e)
      }
    } else {
      loadErrors.push(new Error(`Unsupported architecture on OpenHarmony: ${process.arch}`))
    }
  } else {
    loadErrors.push(new Error(`Unsupported OS: ${process.platform}, architecture: ${process.arch}`))
  }
}

nativeBinding = requireNative()

if (!nativeBinding || process.env.NAPI_RS_FORCE_WASI) {
  try {
    nativeBinding = require('./libcurl.wasi.cjs')
  } catch (err) {
    if (process.env.NAPI_RS_FORCE_WASI) {
      loadErrors.push(err)
    }
  }
  if (!nativeBinding) {
    try {
      nativeBinding = require('@tocha688/libcurl-wasm32-wasi')
    } catch (err) {
      if (process.env.NAPI_RS_FORCE_WASI) {
        loadErrors.push(err)
      }
    }
  }
}

if (!nativeBinding) {
  if (loadErrors.length > 0) {
    throw new Error(
      `Cannot find native binding. ` +
        `npm has a bug related to optional dependencies (https://github.com/npm/cli/issues/4828). ` +
        'Please try `npm i` again after removing both package-lock.json and node_modules directory.',
      { cause: loadErrors }
    )
  }
  throw new Error(`Failed to load native binding`)
}

module.exports = nativeBinding
module.exports.Curl = nativeBinding.Curl
module.exports.CurlMulti = nativeBinding.CurlMulti
module.exports.curlEasyError = nativeBinding.curlEasyError
module.exports.CurlError = nativeBinding.CurlError
module.exports.CurlHttpVersion = nativeBinding.CurlHttpVersion
module.exports.CurlImpersonate = nativeBinding.CurlImpersonate
module.exports.CurlInfo = nativeBinding.CurlInfo
module.exports.CurlIpResolve = nativeBinding.CurlIpResolve
module.exports.CurlMOpt = nativeBinding.CurlMOpt
module.exports.curlMultiError = nativeBinding.curlMultiError
module.exports.CurlOpt = nativeBinding.CurlOpt
module.exports.CurlSslVersion = nativeBinding.CurlSslVersion
module.exports.CurlWsFlag = nativeBinding.CurlWsFlag
module.exports.getDefaultDirName = nativeBinding.getDefaultDirName
module.exports.getDefaultLibPath = nativeBinding.getDefaultLibPath
module.exports.getLibPath = nativeBinding.getLibPath
module.exports.getVersion = nativeBinding.getVersion
module.exports.globalCleanup = nativeBinding.globalCleanup
module.exports.globalInit = nativeBinding.globalInit
module.exports.setLibPath = nativeBinding.setLibPath
module.exports.socketIsReadable = nativeBinding.socketIsReadable
module.exports.socketIsWritable = nativeBinding.socketIsWritable
