"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.encrypt = exports.CardTypes = void 0;
const jwt_decode_1 = __importDefault(require("jwt-decode"));
const webcrypto_1 = require("@peculiar/webcrypto");
const utils_1 = require("./utils");
exports.CardTypes = {
    Visa: '001',
    MasterCard: '002',
    AmericanExpress: '003',
    Discover: '004',
    Diners: '005',
    JCB: '007',
    Maestro: '042',
    ChinaUnionPay: '062',
};
exports.encrypt = async (data, context, index = 0) => {
    const crypto = new webcrypto_1.Crypto();
    const keyId = jwt_decode_1.default(context);
    const header = {
        kid: keyId.flx.jwk.kid,
        alg: 'RSA-OAEP',
        enc: 'A256GCM'
    };
    const payload = {
        data,
        context,
        index
    };
    const iv = crypto.getRandomValues(new Uint8Array(12));
    return utils_1.generateKey(crypto)
        .then((key) => utils_1._encrypt(crypto, payload, key, header, iv))
        .then((data) => {
        const [buffer, key] = data;
        return utils_1.build(crypto, buffer, key, iv, header, keyId.flx.jwk);
    });
};
