import { Header, InitializationVector, Payload } from '../types';
export declare const generateKey: (crypto: Crypto) => Promise<CryptoKey>;
export declare const _encrypt: (crypto: Crypto, payload: Payload, key: CryptoKey, header: Header, iv: InitializationVector) => Promise<[ArrayBuffer, CryptoKey]>;
export declare const importKey: (crypto: Crypto, jsonWebKey: JsonWebKey) => Promise<CryptoKey>;
export declare const wrapKey: (crypto: Crypto, key: CryptoKey, jsonWebKey: JsonWebKey) => Promise<ArrayBuffer>;
export declare const build: (crypto: Crypto, buffer: ArrayBuffer, key: CryptoKey, iv: InitializationVector, header: Header, jsonWebKey: JsonWebKey) => Promise<string>;
export declare const arrayBufferToString: (buf: ArrayBuffer) => string;
export declare const stringToArrayBuffer: (str: string) => ArrayBuffer;
export declare const replace: (str: string) => string;
