"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; } function _nullishCoalesce(lhs, rhsFn) { if (lhs != null) { return lhs; } else { return rhsFn(); } } function _optionalChain(ops) { let lastAccessLHS = undefined; let value = ops[0]; let i = 1; while (i < ops.length) { const op = ops[i]; const fn = ops[i + 1]; i += 2; if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) { return undefined; } if (op === 'access' || op === 'optionalAccess') { lastAccessLHS = value; value = fn(value); } else if (op === 'call' || op === 'optionalCall') { value = fn((...args) => value.call(lastAccessLHS, ...args)); lastAccessLHS = undefined; } } return value; }var __defProp = Object.defineProperty;
var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
  get: (a, b) => (typeof require !== "undefined" ? require : a)[b]
}) : x)(function(x) {
  if (typeof require !== "undefined") return require.apply(this, arguments);
  throw Error('Dynamic require of "' + x + '" is not supported');
});
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// src/core/curl.ts
var _koffi = require('koffi'); var _koffi2 = _interopRequireDefault(_koffi);

// src/bindings/constants.ts
var constants_exports = {};
__export(constants_exports, {
  CURLE: () => CURLE,
  CURLINFO: () => CURLINFO,
  CURLOPT: () => CURLOPT,
  CURL_HTTP_VERSION: () => CURL_HTTP_VERSION,
  CURL_IP_RESOLVE: () => CURL_IP_RESOLVE,
  CURL_SSLVERSION: () => CURL_SSLVERSION
});
var CURLOPT = /* @__PURE__ */ ((CURLOPT2) => {
  CURLOPT2[CURLOPT2["WRITEDATA"] = 10001] = "WRITEDATA";
  CURLOPT2[CURLOPT2["URL"] = 10002] = "URL";
  CURLOPT2[CURLOPT2["PORT"] = 3] = "PORT";
  CURLOPT2[CURLOPT2["PROXY"] = 10004] = "PROXY";
  CURLOPT2[CURLOPT2["USERPWD"] = 10005] = "USERPWD";
  CURLOPT2[CURLOPT2["PROXYUSERPWD"] = 10006] = "PROXYUSERPWD";
  CURLOPT2[CURLOPT2["RANGE"] = 10007] = "RANGE";
  CURLOPT2[CURLOPT2["READDATA"] = 10009] = "READDATA";
  CURLOPT2[CURLOPT2["ERRORBUFFER"] = 10010] = "ERRORBUFFER";
  CURLOPT2[CURLOPT2["WRITEFUNCTION"] = 20011] = "WRITEFUNCTION";
  CURLOPT2[CURLOPT2["READFUNCTION"] = 20012] = "READFUNCTION";
  CURLOPT2[CURLOPT2["TIMEOUT"] = 13] = "TIMEOUT";
  CURLOPT2[CURLOPT2["INFILESIZE"] = 14] = "INFILESIZE";
  CURLOPT2[CURLOPT2["POSTFIELDS"] = 10015] = "POSTFIELDS";
  CURLOPT2[CURLOPT2["REFERER"] = 10016] = "REFERER";
  CURLOPT2[CURLOPT2["FTPPORT"] = 10017] = "FTPPORT";
  CURLOPT2[CURLOPT2["USERAGENT"] = 10018] = "USERAGENT";
  CURLOPT2[CURLOPT2["LOW_SPEED_LIMIT"] = 19] = "LOW_SPEED_LIMIT";
  CURLOPT2[CURLOPT2["LOW_SPEED_TIME"] = 20] = "LOW_SPEED_TIME";
  CURLOPT2[CURLOPT2["RESUME_FROM"] = 21] = "RESUME_FROM";
  CURLOPT2[CURLOPT2["COOKIE"] = 10022] = "COOKIE";
  CURLOPT2[CURLOPT2["HTTPHEADER"] = 10023] = "HTTPHEADER";
  CURLOPT2[CURLOPT2["HTTPPOST"] = 10024] = "HTTPPOST";
  CURLOPT2[CURLOPT2["SSLCERT"] = 10025] = "SSLCERT";
  CURLOPT2[CURLOPT2["KEYPASSWD"] = 10026] = "KEYPASSWD";
  CURLOPT2[CURLOPT2["CRLF"] = 27] = "CRLF";
  CURLOPT2[CURLOPT2["QUOTE"] = 10028] = "QUOTE";
  CURLOPT2[CURLOPT2["HEADERDATA"] = 10029] = "HEADERDATA";
  CURLOPT2[CURLOPT2["COOKIEFILE"] = 10031] = "COOKIEFILE";
  CURLOPT2[CURLOPT2["SSLVERSION"] = 32] = "SSLVERSION";
  CURLOPT2[CURLOPT2["TIMECONDITION"] = 33] = "TIMECONDITION";
  CURLOPT2[CURLOPT2["TIMEVALUE"] = 34] = "TIMEVALUE";
  CURLOPT2[CURLOPT2["CUSTOMREQUEST"] = 10036] = "CUSTOMREQUEST";
  CURLOPT2[CURLOPT2["STDERR"] = 10037] = "STDERR";
  CURLOPT2[CURLOPT2["POSTQUOTE"] = 10039] = "POSTQUOTE";
  CURLOPT2[CURLOPT2["VERBOSE"] = 41] = "VERBOSE";
  CURLOPT2[CURLOPT2["HEADER"] = 42] = "HEADER";
  CURLOPT2[CURLOPT2["NOPROGRESS"] = 43] = "NOPROGRESS";
  CURLOPT2[CURLOPT2["NOBODY"] = 44] = "NOBODY";
  CURLOPT2[CURLOPT2["FAILONERROR"] = 45] = "FAILONERROR";
  CURLOPT2[CURLOPT2["UPLOAD"] = 46] = "UPLOAD";
  CURLOPT2[CURLOPT2["POST"] = 47] = "POST";
  CURLOPT2[CURLOPT2["DIRLISTONLY"] = 48] = "DIRLISTONLY";
  CURLOPT2[CURLOPT2["APPEND"] = 50] = "APPEND";
  CURLOPT2[CURLOPT2["NETRC"] = 51] = "NETRC";
  CURLOPT2[CURLOPT2["FOLLOWLOCATION"] = 52] = "FOLLOWLOCATION";
  CURLOPT2[CURLOPT2["TRANSFERTEXT"] = 53] = "TRANSFERTEXT";
  CURLOPT2[CURLOPT2["PUT"] = 54] = "PUT";
  CURLOPT2[CURLOPT2["PROGRESSFUNCTION"] = 20056] = "PROGRESSFUNCTION";
  CURLOPT2[CURLOPT2["XFERINFODATA"] = 10057] = "XFERINFODATA";
  CURLOPT2[CURLOPT2["AUTOREFERER"] = 58] = "AUTOREFERER";
  CURLOPT2[CURLOPT2["PROXYPORT"] = 59] = "PROXYPORT";
  CURLOPT2[CURLOPT2["POSTFIELDSIZE"] = 60] = "POSTFIELDSIZE";
  CURLOPT2[CURLOPT2["HTTPPROXYTUNNEL"] = 61] = "HTTPPROXYTUNNEL";
  CURLOPT2[CURLOPT2["INTERFACE"] = 10062] = "INTERFACE";
  CURLOPT2[CURLOPT2["KRBLEVEL"] = 10063] = "KRBLEVEL";
  CURLOPT2[CURLOPT2["SSL_VERIFYPEER"] = 64] = "SSL_VERIFYPEER";
  CURLOPT2[CURLOPT2["CAINFO"] = 10065] = "CAINFO";
  CURLOPT2[CURLOPT2["MAXREDIRS"] = 68] = "MAXREDIRS";
  CURLOPT2[CURLOPT2["FILETIME"] = 69] = "FILETIME";
  CURLOPT2[CURLOPT2["TELNETOPTIONS"] = 10070] = "TELNETOPTIONS";
  CURLOPT2[CURLOPT2["MAXCONNECTS"] = 71] = "MAXCONNECTS";
  CURLOPT2[CURLOPT2["FRESH_CONNECT"] = 74] = "FRESH_CONNECT";
  CURLOPT2[CURLOPT2["FORBID_REUSE"] = 75] = "FORBID_REUSE";
  CURLOPT2[CURLOPT2["RANDOM_FILE"] = 10076] = "RANDOM_FILE";
  CURLOPT2[CURLOPT2["EGDSOCKET"] = 10077] = "EGDSOCKET";
  CURLOPT2[CURLOPT2["CONNECTTIMEOUT"] = 78] = "CONNECTTIMEOUT";
  CURLOPT2[CURLOPT2["HEADERFUNCTION"] = 20079] = "HEADERFUNCTION";
  CURLOPT2[CURLOPT2["HTTPGET"] = 80] = "HTTPGET";
  CURLOPT2[CURLOPT2["SSL_VERIFYHOST"] = 81] = "SSL_VERIFYHOST";
  CURLOPT2[CURLOPT2["COOKIEJAR"] = 10082] = "COOKIEJAR";
  CURLOPT2[CURLOPT2["SSL_CIPHER_LIST"] = 10083] = "SSL_CIPHER_LIST";
  CURLOPT2[CURLOPT2["HTTP_VERSION"] = 84] = "HTTP_VERSION";
  CURLOPT2[CURLOPT2["FTP_USE_EPSV"] = 85] = "FTP_USE_EPSV";
  CURLOPT2[CURLOPT2["SSLCERTTYPE"] = 10086] = "SSLCERTTYPE";
  CURLOPT2[CURLOPT2["SSLKEY"] = 10087] = "SSLKEY";
  CURLOPT2[CURLOPT2["SSLKEYTYPE"] = 10088] = "SSLKEYTYPE";
  CURLOPT2[CURLOPT2["SSLENGINE"] = 10089] = "SSLENGINE";
  CURLOPT2[CURLOPT2["SSLENGINE_DEFAULT"] = 90] = "SSLENGINE_DEFAULT";
  CURLOPT2[CURLOPT2["DNS_USE_GLOBAL_CACHE"] = 91] = "DNS_USE_GLOBAL_CACHE";
  CURLOPT2[CURLOPT2["DNS_CACHE_TIMEOUT"] = 92] = "DNS_CACHE_TIMEOUT";
  CURLOPT2[CURLOPT2["PREQUOTE"] = 10093] = "PREQUOTE";
  CURLOPT2[CURLOPT2["DEBUGFUNCTION"] = 20094] = "DEBUGFUNCTION";
  CURLOPT2[CURLOPT2["DEBUGDATA"] = 10095] = "DEBUGDATA";
  CURLOPT2[CURLOPT2["COOKIESESSION"] = 96] = "COOKIESESSION";
  CURLOPT2[CURLOPT2["CAPATH"] = 10097] = "CAPATH";
  CURLOPT2[CURLOPT2["BUFFERSIZE"] = 98] = "BUFFERSIZE";
  CURLOPT2[CURLOPT2["NOSIGNAL"] = 99] = "NOSIGNAL";
  CURLOPT2[CURLOPT2["SHARE"] = 10100] = "SHARE";
  CURLOPT2[CURLOPT2["PROXYTYPE"] = 101] = "PROXYTYPE";
  CURLOPT2[CURLOPT2["ACCEPT_ENCODING"] = 10102] = "ACCEPT_ENCODING";
  CURLOPT2[CURLOPT2["PRIVATE"] = 10103] = "PRIVATE";
  CURLOPT2[CURLOPT2["HTTP200ALIASES"] = 10104] = "HTTP200ALIASES";
  CURLOPT2[CURLOPT2["UNRESTRICTED_AUTH"] = 105] = "UNRESTRICTED_AUTH";
  CURLOPT2[CURLOPT2["FTP_USE_EPRT"] = 106] = "FTP_USE_EPRT";
  CURLOPT2[CURLOPT2["HTTPAUTH"] = 107] = "HTTPAUTH";
  CURLOPT2[CURLOPT2["SSL_CTX_FUNCTION"] = 20108] = "SSL_CTX_FUNCTION";
  CURLOPT2[CURLOPT2["SSL_CTX_DATA"] = 10109] = "SSL_CTX_DATA";
  CURLOPT2[CURLOPT2["FTP_CREATE_MISSING_DIRS"] = 110] = "FTP_CREATE_MISSING_DIRS";
  CURLOPT2[CURLOPT2["PROXYAUTH"] = 111] = "PROXYAUTH";
  CURLOPT2[CURLOPT2["SERVER_RESPONSE_TIMEOUT"] = 112] = "SERVER_RESPONSE_TIMEOUT";
  CURLOPT2[CURLOPT2["IPRESOLVE"] = 113] = "IPRESOLVE";
  CURLOPT2[CURLOPT2["MAXFILESIZE"] = 114] = "MAXFILESIZE";
  CURLOPT2[CURLOPT2["INFILESIZE_LARGE"] = 30115] = "INFILESIZE_LARGE";
  CURLOPT2[CURLOPT2["RESUME_FROM_LARGE"] = 30116] = "RESUME_FROM_LARGE";
  CURLOPT2[CURLOPT2["MAXFILESIZE_LARGE"] = 30117] = "MAXFILESIZE_LARGE";
  CURLOPT2[CURLOPT2["NETRC_FILE"] = 10118] = "NETRC_FILE";
  CURLOPT2[CURLOPT2["USE_SSL"] = 119] = "USE_SSL";
  CURLOPT2[CURLOPT2["POSTFIELDSIZE_LARGE"] = 30120] = "POSTFIELDSIZE_LARGE";
  CURLOPT2[CURLOPT2["TCP_NODELAY"] = 121] = "TCP_NODELAY";
  CURLOPT2[CURLOPT2["FTPSSLAUTH"] = 129] = "FTPSSLAUTH";
  CURLOPT2[CURLOPT2["IOCTLFUNCTION"] = 20130] = "IOCTLFUNCTION";
  CURLOPT2[CURLOPT2["IOCTLDATA"] = 10131] = "IOCTLDATA";
  CURLOPT2[CURLOPT2["FTP_ACCOUNT"] = 10134] = "FTP_ACCOUNT";
  CURLOPT2[CURLOPT2["COOKIELIST"] = 10135] = "COOKIELIST";
  CURLOPT2[CURLOPT2["IGNORE_CONTENT_LENGTH"] = 136] = "IGNORE_CONTENT_LENGTH";
  CURLOPT2[CURLOPT2["FTP_SKIP_PASV_IP"] = 137] = "FTP_SKIP_PASV_IP";
  CURLOPT2[CURLOPT2["FTP_FILEMETHOD"] = 138] = "FTP_FILEMETHOD";
  CURLOPT2[CURLOPT2["LOCALPORT"] = 139] = "LOCALPORT";
  CURLOPT2[CURLOPT2["LOCALPORTRANGE"] = 140] = "LOCALPORTRANGE";
  CURLOPT2[CURLOPT2["CONNECT_ONLY"] = 141] = "CONNECT_ONLY";
  CURLOPT2[CURLOPT2["CONV_FROM_NETWORK_FUNCTION"] = 20142] = "CONV_FROM_NETWORK_FUNCTION";
  CURLOPT2[CURLOPT2["CONV_TO_NETWORK_FUNCTION"] = 20143] = "CONV_TO_NETWORK_FUNCTION";
  CURLOPT2[CURLOPT2["CONV_FROM_UTF8_FUNCTION"] = 20144] = "CONV_FROM_UTF8_FUNCTION";
  CURLOPT2[CURLOPT2["MAX_SEND_SPEED_LARGE"] = 30145] = "MAX_SEND_SPEED_LARGE";
  CURLOPT2[CURLOPT2["MAX_RECV_SPEED_LARGE"] = 30146] = "MAX_RECV_SPEED_LARGE";
  CURLOPT2[CURLOPT2["FTP_ALTERNATIVE_TO_USER"] = 10147] = "FTP_ALTERNATIVE_TO_USER";
  CURLOPT2[CURLOPT2["SOCKOPTFUNCTION"] = 20148] = "SOCKOPTFUNCTION";
  CURLOPT2[CURLOPT2["SOCKOPTDATA"] = 10149] = "SOCKOPTDATA";
  CURLOPT2[CURLOPT2["SSL_SESSIONID_CACHE"] = 150] = "SSL_SESSIONID_CACHE";
  CURLOPT2[CURLOPT2["SSH_AUTH_TYPES"] = 151] = "SSH_AUTH_TYPES";
  CURLOPT2[CURLOPT2["SSH_PUBLIC_KEYFILE"] = 10152] = "SSH_PUBLIC_KEYFILE";
  CURLOPT2[CURLOPT2["SSH_PRIVATE_KEYFILE"] = 10153] = "SSH_PRIVATE_KEYFILE";
  CURLOPT2[CURLOPT2["FTP_SSL_CCC"] = 154] = "FTP_SSL_CCC";
  CURLOPT2[CURLOPT2["TIMEOUT_MS"] = 155] = "TIMEOUT_MS";
  CURLOPT2[CURLOPT2["CONNECTTIMEOUT_MS"] = 156] = "CONNECTTIMEOUT_MS";
  CURLOPT2[CURLOPT2["HTTP_TRANSFER_DECODING"] = 157] = "HTTP_TRANSFER_DECODING";
  CURLOPT2[CURLOPT2["HTTP_CONTENT_DECODING"] = 158] = "HTTP_CONTENT_DECODING";
  CURLOPT2[CURLOPT2["NEW_FILE_PERMS"] = 159] = "NEW_FILE_PERMS";
  CURLOPT2[CURLOPT2["NEW_DIRECTORY_PERMS"] = 160] = "NEW_DIRECTORY_PERMS";
  CURLOPT2[CURLOPT2["POSTREDIR"] = 161] = "POSTREDIR";
  CURLOPT2[CURLOPT2["SSH_HOST_PUBLIC_KEY_MD5"] = 10162] = "SSH_HOST_PUBLIC_KEY_MD5";
  CURLOPT2[CURLOPT2["OPENSOCKETFUNCTION"] = 20163] = "OPENSOCKETFUNCTION";
  CURLOPT2[CURLOPT2["OPENSOCKETDATA"] = 10164] = "OPENSOCKETDATA";
  CURLOPT2[CURLOPT2["COPYPOSTFIELDS"] = 10165] = "COPYPOSTFIELDS";
  CURLOPT2[CURLOPT2["PROXY_TRANSFER_MODE"] = 166] = "PROXY_TRANSFER_MODE";
  CURLOPT2[CURLOPT2["SEEKFUNCTION"] = 20167] = "SEEKFUNCTION";
  CURLOPT2[CURLOPT2["SEEKDATA"] = 10168] = "SEEKDATA";
  CURLOPT2[CURLOPT2["CRLFILE"] = 10169] = "CRLFILE";
  CURLOPT2[CURLOPT2["ISSUERCERT"] = 10170] = "ISSUERCERT";
  CURLOPT2[CURLOPT2["ADDRESS_SCOPE"] = 171] = "ADDRESS_SCOPE";
  CURLOPT2[CURLOPT2["CERTINFO"] = 172] = "CERTINFO";
  CURLOPT2[CURLOPT2["USERNAME"] = 10173] = "USERNAME";
  CURLOPT2[CURLOPT2["PASSWORD"] = 10174] = "PASSWORD";
  CURLOPT2[CURLOPT2["PROXYUSERNAME"] = 10175] = "PROXYUSERNAME";
  CURLOPT2[CURLOPT2["PROXYPASSWORD"] = 10176] = "PROXYPASSWORD";
  CURLOPT2[CURLOPT2["NOPROXY"] = 10177] = "NOPROXY";
  CURLOPT2[CURLOPT2["TFTP_BLKSIZE"] = 178] = "TFTP_BLKSIZE";
  CURLOPT2[CURLOPT2["SOCKS5_GSSAPI_SERVICE"] = 10179] = "SOCKS5_GSSAPI_SERVICE";
  CURLOPT2[CURLOPT2["SOCKS5_GSSAPI_NEC"] = 180] = "SOCKS5_GSSAPI_NEC";
  CURLOPT2[CURLOPT2["PROTOCOLS"] = 181] = "PROTOCOLS";
  CURLOPT2[CURLOPT2["REDIR_PROTOCOLS"] = 182] = "REDIR_PROTOCOLS";
  CURLOPT2[CURLOPT2["SSH_KNOWNHOSTS"] = 10183] = "SSH_KNOWNHOSTS";
  CURLOPT2[CURLOPT2["SSH_KEYFUNCTION"] = 20184] = "SSH_KEYFUNCTION";
  CURLOPT2[CURLOPT2["SSH_KEYDATA"] = 10185] = "SSH_KEYDATA";
  CURLOPT2[CURLOPT2["MAIL_FROM"] = 10186] = "MAIL_FROM";
  CURLOPT2[CURLOPT2["MAIL_RCPT"] = 10187] = "MAIL_RCPT";
  CURLOPT2[CURLOPT2["FTP_USE_PRET"] = 188] = "FTP_USE_PRET";
  CURLOPT2[CURLOPT2["RTSP_REQUEST"] = 189] = "RTSP_REQUEST";
  CURLOPT2[CURLOPT2["RTSP_SESSION_ID"] = 10190] = "RTSP_SESSION_ID";
  CURLOPT2[CURLOPT2["RTSP_STREAM_URI"] = 10191] = "RTSP_STREAM_URI";
  CURLOPT2[CURLOPT2["RTSP_TRANSPORT"] = 10192] = "RTSP_TRANSPORT";
  CURLOPT2[CURLOPT2["RTSP_CLIENT_CSEQ"] = 193] = "RTSP_CLIENT_CSEQ";
  CURLOPT2[CURLOPT2["RTSP_SERVER_CSEQ"] = 194] = "RTSP_SERVER_CSEQ";
  CURLOPT2[CURLOPT2["INTERLEAVEDATA"] = 10195] = "INTERLEAVEDATA";
  CURLOPT2[CURLOPT2["INTERLEAVEFUNCTION"] = 20196] = "INTERLEAVEFUNCTION";
  CURLOPT2[CURLOPT2["WILDCARDMATCH"] = 197] = "WILDCARDMATCH";
  CURLOPT2[CURLOPT2["CHUNK_BGN_FUNCTION"] = 20198] = "CHUNK_BGN_FUNCTION";
  CURLOPT2[CURLOPT2["CHUNK_END_FUNCTION"] = 20199] = "CHUNK_END_FUNCTION";
  CURLOPT2[CURLOPT2["FNMATCH_FUNCTION"] = 20200] = "FNMATCH_FUNCTION";
  CURLOPT2[CURLOPT2["CHUNK_DATA"] = 10201] = "CHUNK_DATA";
  CURLOPT2[CURLOPT2["FNMATCH_DATA"] = 10202] = "FNMATCH_DATA";
  CURLOPT2[CURLOPT2["RESOLVE"] = 10203] = "RESOLVE";
  CURLOPT2[CURLOPT2["TLSAUTH_USERNAME"] = 10204] = "TLSAUTH_USERNAME";
  CURLOPT2[CURLOPT2["TLSAUTH_PASSWORD"] = 10205] = "TLSAUTH_PASSWORD";
  CURLOPT2[CURLOPT2["TLSAUTH_TYPE"] = 10206] = "TLSAUTH_TYPE";
  CURLOPT2[CURLOPT2["TRANSFER_ENCODING"] = 207] = "TRANSFER_ENCODING";
  CURLOPT2[CURLOPT2["CLOSESOCKETFUNCTION"] = 20208] = "CLOSESOCKETFUNCTION";
  CURLOPT2[CURLOPT2["CLOSESOCKETDATA"] = 10209] = "CLOSESOCKETDATA";
  CURLOPT2[CURLOPT2["GSSAPI_DELEGATION"] = 210] = "GSSAPI_DELEGATION";
  CURLOPT2[CURLOPT2["DNS_SERVERS"] = 10211] = "DNS_SERVERS";
  CURLOPT2[CURLOPT2["ACCEPTTIMEOUT_MS"] = 212] = "ACCEPTTIMEOUT_MS";
  CURLOPT2[CURLOPT2["TCP_KEEPALIVE"] = 213] = "TCP_KEEPALIVE";
  CURLOPT2[CURLOPT2["TCP_KEEPIDLE"] = 214] = "TCP_KEEPIDLE";
  CURLOPT2[CURLOPT2["TCP_KEEPINTVL"] = 215] = "TCP_KEEPINTVL";
  CURLOPT2[CURLOPT2["SSL_OPTIONS"] = 216] = "SSL_OPTIONS";
  CURLOPT2[CURLOPT2["MAIL_AUTH"] = 10217] = "MAIL_AUTH";
  CURLOPT2[CURLOPT2["SASL_IR"] = 218] = "SASL_IR";
  CURLOPT2[CURLOPT2["XFERINFOFUNCTION"] = 20219] = "XFERINFOFUNCTION";
  CURLOPT2[CURLOPT2["XOAUTH2_BEARER"] = 10220] = "XOAUTH2_BEARER";
  CURLOPT2[CURLOPT2["DNS_INTERFACE"] = 10221] = "DNS_INTERFACE";
  CURLOPT2[CURLOPT2["DNS_LOCAL_IP4"] = 10222] = "DNS_LOCAL_IP4";
  CURLOPT2[CURLOPT2["DNS_LOCAL_IP6"] = 10223] = "DNS_LOCAL_IP6";
  CURLOPT2[CURLOPT2["LOGIN_OPTIONS"] = 10224] = "LOGIN_OPTIONS";
  CURLOPT2[CURLOPT2["SSL_ENABLE_NPN"] = 225] = "SSL_ENABLE_NPN";
  CURLOPT2[CURLOPT2["SSL_ENABLE_ALPN"] = 226] = "SSL_ENABLE_ALPN";
  CURLOPT2[CURLOPT2["EXPECT_100_TIMEOUT_MS"] = 227] = "EXPECT_100_TIMEOUT_MS";
  CURLOPT2[CURLOPT2["PROXYHEADER"] = 10228] = "PROXYHEADER";
  CURLOPT2[CURLOPT2["HEADEROPT"] = 229] = "HEADEROPT";
  CURLOPT2[CURLOPT2["PINNEDPUBLICKEY"] = 10230] = "PINNEDPUBLICKEY";
  CURLOPT2[CURLOPT2["UNIX_SOCKET_PATH"] = 10231] = "UNIX_SOCKET_PATH";
  CURLOPT2[CURLOPT2["SSL_VERIFYSTATUS"] = 232] = "SSL_VERIFYSTATUS";
  CURLOPT2[CURLOPT2["SSL_FALSESTART"] = 233] = "SSL_FALSESTART";
  CURLOPT2[CURLOPT2["PATH_AS_IS"] = 234] = "PATH_AS_IS";
  CURLOPT2[CURLOPT2["PROXY_SERVICE_NAME"] = 10235] = "PROXY_SERVICE_NAME";
  CURLOPT2[CURLOPT2["SERVICE_NAME"] = 10236] = "SERVICE_NAME";
  CURLOPT2[CURLOPT2["PIPEWAIT"] = 237] = "PIPEWAIT";
  CURLOPT2[CURLOPT2["DEFAULT_PROTOCOL"] = 10238] = "DEFAULT_PROTOCOL";
  CURLOPT2[CURLOPT2["STREAM_WEIGHT"] = 239] = "STREAM_WEIGHT";
  CURLOPT2[CURLOPT2["STREAM_DEPENDS"] = 10240] = "STREAM_DEPENDS";
  CURLOPT2[CURLOPT2["STREAM_DEPENDS_E"] = 10241] = "STREAM_DEPENDS_E";
  CURLOPT2[CURLOPT2["TFTP_NO_OPTIONS"] = 242] = "TFTP_NO_OPTIONS";
  CURLOPT2[CURLOPT2["CONNECT_TO"] = 10243] = "CONNECT_TO";
  CURLOPT2[CURLOPT2["TCP_FASTOPEN"] = 244] = "TCP_FASTOPEN";
  CURLOPT2[CURLOPT2["KEEP_SENDING_ON_ERROR"] = 245] = "KEEP_SENDING_ON_ERROR";
  CURLOPT2[CURLOPT2["PROXY_CAINFO"] = 10246] = "PROXY_CAINFO";
  CURLOPT2[CURLOPT2["PROXY_CAPATH"] = 10247] = "PROXY_CAPATH";
  CURLOPT2[CURLOPT2["PROXY_SSL_VERIFYPEER"] = 248] = "PROXY_SSL_VERIFYPEER";
  CURLOPT2[CURLOPT2["PROXY_SSL_VERIFYHOST"] = 249] = "PROXY_SSL_VERIFYHOST";
  CURLOPT2[CURLOPT2["PROXY_SSLVERSION"] = 250] = "PROXY_SSLVERSION";
  CURLOPT2[CURLOPT2["PROXY_TLSAUTH_USERNAME"] = 10251] = "PROXY_TLSAUTH_USERNAME";
  CURLOPT2[CURLOPT2["PROXY_TLSAUTH_PASSWORD"] = 10252] = "PROXY_TLSAUTH_PASSWORD";
  CURLOPT2[CURLOPT2["PROXY_TLSAUTH_TYPE"] = 10253] = "PROXY_TLSAUTH_TYPE";
  CURLOPT2[CURLOPT2["PROXY_SSLCERT"] = 10254] = "PROXY_SSLCERT";
  CURLOPT2[CURLOPT2["PROXY_SSLCERTTYPE"] = 10255] = "PROXY_SSLCERTTYPE";
  CURLOPT2[CURLOPT2["PROXY_SSLKEY"] = 10256] = "PROXY_SSLKEY";
  CURLOPT2[CURLOPT2["PROXY_SSLKEYTYPE"] = 10257] = "PROXY_SSLKEYTYPE";
  CURLOPT2[CURLOPT2["PROXY_KEYPASSWD"] = 10258] = "PROXY_KEYPASSWD";
  CURLOPT2[CURLOPT2["PROXY_SSL_CIPHER_LIST"] = 10259] = "PROXY_SSL_CIPHER_LIST";
  CURLOPT2[CURLOPT2["PROXY_CRLFILE"] = 10260] = "PROXY_CRLFILE";
  CURLOPT2[CURLOPT2["PROXY_SSL_OPTIONS"] = 261] = "PROXY_SSL_OPTIONS";
  CURLOPT2[CURLOPT2["PRE_PROXY"] = 10262] = "PRE_PROXY";
  CURLOPT2[CURLOPT2["PROXY_PINNEDPUBLICKEY"] = 10263] = "PROXY_PINNEDPUBLICKEY";
  CURLOPT2[CURLOPT2["ABSTRACT_UNIX_SOCKET"] = 10264] = "ABSTRACT_UNIX_SOCKET";
  CURLOPT2[CURLOPT2["SUPPRESS_CONNECT_HEADERS"] = 265] = "SUPPRESS_CONNECT_HEADERS";
  CURLOPT2[CURLOPT2["REQUEST_TARGET"] = 10266] = "REQUEST_TARGET";
  CURLOPT2[CURLOPT2["SOCKS5_AUTH"] = 267] = "SOCKS5_AUTH";
  CURLOPT2[CURLOPT2["SSH_COMPRESSION"] = 268] = "SSH_COMPRESSION";
  CURLOPT2[CURLOPT2["MIMEPOST"] = 10269] = "MIMEPOST";
  CURLOPT2[CURLOPT2["TIMEVALUE_LARGE"] = 30270] = "TIMEVALUE_LARGE";
  CURLOPT2[CURLOPT2["HAPPY_EYEBALLS_TIMEOUT_MS"] = 271] = "HAPPY_EYEBALLS_TIMEOUT_MS";
  CURLOPT2[CURLOPT2["RESOLVER_START_FUNCTION"] = 20272] = "RESOLVER_START_FUNCTION";
  CURLOPT2[CURLOPT2["RESOLVER_START_DATA"] = 10273] = "RESOLVER_START_DATA";
  CURLOPT2[CURLOPT2["HAPROXYPROTOCOL"] = 274] = "HAPROXYPROTOCOL";
  CURLOPT2[CURLOPT2["DNS_SHUFFLE_ADDRESSES"] = 275] = "DNS_SHUFFLE_ADDRESSES";
  CURLOPT2[CURLOPT2["TLS13_CIPHERS"] = 10276] = "TLS13_CIPHERS";
  CURLOPT2[CURLOPT2["PROXY_TLS13_CIPHERS"] = 10277] = "PROXY_TLS13_CIPHERS";
  CURLOPT2[CURLOPT2["DISALLOW_USERNAME_IN_URL"] = 278] = "DISALLOW_USERNAME_IN_URL";
  CURLOPT2[CURLOPT2["DOH_URL"] = 10279] = "DOH_URL";
  CURLOPT2[CURLOPT2["UPLOAD_BUFFERSIZE"] = 280] = "UPLOAD_BUFFERSIZE";
  CURLOPT2[CURLOPT2["UPKEEP_INTERVAL_MS"] = 281] = "UPKEEP_INTERVAL_MS";
  CURLOPT2[CURLOPT2["CURLU"] = 10282] = "CURLU";
  CURLOPT2[CURLOPT2["TRAILERFUNCTION"] = 20283] = "TRAILERFUNCTION";
  CURLOPT2[CURLOPT2["TRAILERDATA"] = 10284] = "TRAILERDATA";
  CURLOPT2[CURLOPT2["HTTP09_ALLOWED"] = 285] = "HTTP09_ALLOWED";
  CURLOPT2[CURLOPT2["ALTSVC_CTRL"] = 286] = "ALTSVC_CTRL";
  CURLOPT2[CURLOPT2["ALTSVC"] = 10287] = "ALTSVC";
  CURLOPT2[CURLOPT2["MAXAGE_CONN"] = 288] = "MAXAGE_CONN";
  CURLOPT2[CURLOPT2["SASL_AUTHZID"] = 10289] = "SASL_AUTHZID";
  CURLOPT2[CURLOPT2["MAIL_RCPT_ALLOWFAILS"] = 290] = "MAIL_RCPT_ALLOWFAILS";
  CURLOPT2[CURLOPT2["SSLCERT_BLOB"] = 40291] = "SSLCERT_BLOB";
  CURLOPT2[CURLOPT2["SSLKEY_BLOB"] = 40292] = "SSLKEY_BLOB";
  CURLOPT2[CURLOPT2["PROXY_SSLCERT_BLOB"] = 40293] = "PROXY_SSLCERT_BLOB";
  CURLOPT2[CURLOPT2["PROXY_SSLKEY_BLOB"] = 40294] = "PROXY_SSLKEY_BLOB";
  CURLOPT2[CURLOPT2["ISSUERCERT_BLOB"] = 40295] = "ISSUERCERT_BLOB";
  CURLOPT2[CURLOPT2["PROXY_ISSUERCERT"] = 10296] = "PROXY_ISSUERCERT";
  CURLOPT2[CURLOPT2["PROXY_ISSUERCERT_BLOB"] = 40297] = "PROXY_ISSUERCERT_BLOB";
  CURLOPT2[CURLOPT2["SSL_EC_CURVES"] = 10298] = "SSL_EC_CURVES";
  CURLOPT2[CURLOPT2["HSTS_CTRL"] = 299] = "HSTS_CTRL";
  CURLOPT2[CURLOPT2["HSTS"] = 10300] = "HSTS";
  CURLOPT2[CURLOPT2["HSTSREADFUNCTION"] = 20301] = "HSTSREADFUNCTION";
  CURLOPT2[CURLOPT2["HSTSREADDATA"] = 10302] = "HSTSREADDATA";
  CURLOPT2[CURLOPT2["HSTSWRITEFUNCTION"] = 20303] = "HSTSWRITEFUNCTION";
  CURLOPT2[CURLOPT2["HSTSWRITEDATA"] = 10304] = "HSTSWRITEDATA";
  CURLOPT2[CURLOPT2["AWS_SIGV4"] = 10305] = "AWS_SIGV4";
  CURLOPT2[CURLOPT2["DOH_SSL_VERIFYPEER"] = 306] = "DOH_SSL_VERIFYPEER";
  CURLOPT2[CURLOPT2["DOH_SSL_VERIFYHOST"] = 307] = "DOH_SSL_VERIFYHOST";
  CURLOPT2[CURLOPT2["DOH_SSL_VERIFYSTATUS"] = 308] = "DOH_SSL_VERIFYSTATUS";
  CURLOPT2[CURLOPT2["CAINFO_BLOB"] = 40309] = "CAINFO_BLOB";
  CURLOPT2[CURLOPT2["PROXY_CAINFO_BLOB"] = 40310] = "PROXY_CAINFO_BLOB";
  CURLOPT2[CURLOPT2["SSH_HOST_PUBLIC_KEY_SHA256"] = 10311] = "SSH_HOST_PUBLIC_KEY_SHA256";
  CURLOPT2[CURLOPT2["PREREQFUNCTION"] = 20312] = "PREREQFUNCTION";
  CURLOPT2[CURLOPT2["PREREQDATA"] = 10313] = "PREREQDATA";
  CURLOPT2[CURLOPT2["MAXLIFETIME_CONN"] = 314] = "MAXLIFETIME_CONN";
  CURLOPT2[CURLOPT2["MIME_OPTIONS"] = 315] = "MIME_OPTIONS";
  CURLOPT2[CURLOPT2["SSH_HOSTKEYFUNCTION"] = 20316] = "SSH_HOSTKEYFUNCTION";
  CURLOPT2[CURLOPT2["SSH_HOSTKEYDATA"] = 10317] = "SSH_HOSTKEYDATA";
  CURLOPT2[CURLOPT2["PROTOCOLS_STR"] = 10318] = "PROTOCOLS_STR";
  CURLOPT2[CURLOPT2["REDIR_PROTOCOLS_STR"] = 10319] = "REDIR_PROTOCOLS_STR";
  CURLOPT2[CURLOPT2["WS_OPTIONS"] = 320] = "WS_OPTIONS";
  CURLOPT2[CURLOPT2["CA_CACHE_TIMEOUT"] = 321] = "CA_CACHE_TIMEOUT";
  CURLOPT2[CURLOPT2["QUICK_EXIT"] = 322] = "QUICK_EXIT";
  CURLOPT2[CURLOPT2["HAPROXY_CLIENT_IP"] = 10323] = "HAPROXY_CLIENT_IP";
  CURLOPT2[CURLOPT2["SERVER_RESPONSE_TIMEOUT_MS"] = 324] = "SERVER_RESPONSE_TIMEOUT_MS";
  CURLOPT2[CURLOPT2["ECH"] = 10325] = "ECH";
  CURLOPT2[CURLOPT2["TCP_KEEPCNT"] = 326] = "TCP_KEEPCNT";
  CURLOPT2[CURLOPT2["UPLOAD_FLAGS"] = 327] = "UPLOAD_FLAGS";
  CURLOPT2[CURLOPT2["HTTPBASEHEADER"] = 11e3] = "HTTPBASEHEADER";
  CURLOPT2[CURLOPT2["SSL_SIG_HASH_ALGS"] = 11001] = "SSL_SIG_HASH_ALGS";
  CURLOPT2[CURLOPT2["SSL_ENABLE_ALPS"] = 1002] = "SSL_ENABLE_ALPS";
  CURLOPT2[CURLOPT2["SSL_CERT_COMPRESSION"] = 11003] = "SSL_CERT_COMPRESSION";
  CURLOPT2[CURLOPT2["SSL_ENABLE_TICKET"] = 1004] = "SSL_ENABLE_TICKET";
  CURLOPT2[CURLOPT2["HTTP2_PSEUDO_HEADERS_ORDER"] = 11005] = "HTTP2_PSEUDO_HEADERS_ORDER";
  CURLOPT2[CURLOPT2["HTTP2_SETTINGS"] = 11006] = "HTTP2_SETTINGS";
  CURLOPT2[CURLOPT2["SSL_PERMUTE_EXTENSIONS"] = 1007] = "SSL_PERMUTE_EXTENSIONS";
  CURLOPT2[CURLOPT2["HTTP2_WINDOW_UPDATE"] = 1008] = "HTTP2_WINDOW_UPDATE";
  CURLOPT2[CURLOPT2["HTTP2_STREAMS"] = 11010] = "HTTP2_STREAMS";
  CURLOPT2[CURLOPT2["TLS_GREASE"] = 1011] = "TLS_GREASE";
  CURLOPT2[CURLOPT2["TLS_EXTENSION_ORDER"] = 11012] = "TLS_EXTENSION_ORDER";
  CURLOPT2[CURLOPT2["STREAM_EXCLUSIVE"] = 1013] = "STREAM_EXCLUSIVE";
  CURLOPT2[CURLOPT2["TLS_KEY_USAGE_NO_CHECK"] = 1014] = "TLS_KEY_USAGE_NO_CHECK";
  CURLOPT2[CURLOPT2["TLS_SIGNED_CERT_TIMESTAMPS"] = 1015] = "TLS_SIGNED_CERT_TIMESTAMPS";
  CURLOPT2[CURLOPT2["TLS_STATUS_REQUEST"] = 1016] = "TLS_STATUS_REQUEST";
  CURLOPT2[CURLOPT2["TLS_DELEGATED_CREDENTIALS"] = 11017] = "TLS_DELEGATED_CREDENTIALS";
  CURLOPT2[CURLOPT2["TLS_RECORD_SIZE_LIMIT"] = 1018] = "TLS_RECORD_SIZE_LIMIT";
  CURLOPT2[CURLOPT2["TLS_KEY_SHARES_LIMIT"] = 1019] = "TLS_KEY_SHARES_LIMIT";
  CURLOPT2[CURLOPT2["TLS_USE_NEW_ALPS_CODEPOINT"] = 1020] = "TLS_USE_NEW_ALPS_CODEPOINT";
  CURLOPT2[CURLOPT2["TLS_USE_FIREFOX_TLS13_CIPHERS"] = 1021] = "TLS_USE_FIREFOX_TLS13_CIPHERS";
  return CURLOPT2;
})(CURLOPT || {});
var CURLINFO = {
  TEXT: 0,
  EFFECTIVE_URL: 1048576 + 1,
  RESPONSE_CODE: 2097152 + 2,
  TOTAL_TIME: 3145728 + 3,
  NAMELOOKUP_TIME: 3145728 + 4,
  CONNECT_TIME: 3145728 + 5,
  PRETRANSFER_TIME: 3145728 + 6,
  SIZE_UPLOAD_T: 6291456 + 7,
  SIZE_DOWNLOAD_T: 6291456 + 8,
  SPEED_DOWNLOAD_T: 6291456 + 9,
  SPEED_UPLOAD_T: 6291456 + 10,
  HEADER_SIZE: 2097152 + 11,
  REQUEST_SIZE: 2097152 + 12,
  SSL_VERIFYRESULT: 2097152 + 13,
  FILETIME: 2097152 + 14,
  FILETIME_T: 6291456 + 14,
  CONTENT_LENGTH_DOWNLOAD_T: 6291456 + 15,
  CONTENT_LENGTH_UPLOAD_T: 6291456 + 16,
  STARTTRANSFER_TIME: 3145728 + 17,
  CONTENT_TYPE: 1048576 + 18,
  REDIRECT_TIME: 3145728 + 19,
  REDIRECT_COUNT: 2097152 + 20,
  PRIVATE: 1048576 + 21,
  HTTP_CONNECTCODE: 2097152 + 22,
  HTTPAUTH_AVAIL: 2097152 + 23,
  PROXYAUTH_AVAIL: 2097152 + 24,
  OS_ERRNO: 2097152 + 25,
  NUM_CONNECTS: 2097152 + 26,
  SSL_ENGINES: 4194304 + 27,
  COOKIELIST: 4194304 + 28,
  FTP_ENTRY_PATH: 1048576 + 30,
  REDIRECT_URL: 1048576 + 31,
  PRIMARY_IP: 1048576 + 32,
  APPCONNECT_TIME: 3145728 + 33,
  CERTINFO: 4194304 + 34,
  CONDITION_UNMET: 2097152 + 35,
  RTSP_SESSION_ID: 1048576 + 36,
  RTSP_CLIENT_CSEQ: 2097152 + 37,
  RTSP_SERVER_CSEQ: 2097152 + 38,
  RTSP_CSEQ_RECV: 2097152 + 39,
  PRIMARY_PORT: 2097152 + 40,
  LOCAL_IP: 1048576 + 41,
  LOCAL_PORT: 2097152 + 42,
  ACTIVESOCKET: 5242880 + 44,
  TLS_SSL_PTR: 4194304 + 45,
  HTTP_VERSION: 2097152 + 46,
  PROXY_SSL_VERIFYRESULT: 2097152 + 47,
  SCHEME: 1048576 + 49,
  TOTAL_TIME_T: 6291456 + 50,
  NAMELOOKUP_TIME_T: 6291456 + 51,
  CONNECT_TIME_T: 6291456 + 52,
  PRETRANSFER_TIME_T: 6291456 + 53,
  STARTTRANSFER_TIME_T: 6291456 + 54,
  REDIRECT_TIME_T: 6291456 + 55,
  APPCONNECT_TIME_T: 6291456 + 56,
  RETRY_AFTER: 6291456 + 57,
  EFFECTIVE_METHOD: 1048576 + 58,
  PROXY_ERROR: 2097152 + 59,
  REFERER: 1048576 + 60,
  CAINFO: 1048576 + 61,
  CAPATH: 1048576 + 62,
  XFER_ID: 6291456 + 63,
  CONN_ID: 6291456 + 64,
  QUEUE_TIME_T: 6291456 + 65,
  USED_PROXY: 2097152 + 66,
  POSTTRANSFER_TIME_T: 6291456 + 67,
  EARLYDATA_SENT_T: 6291456 + 68,
  HTTPAUTH_USED: 2097152 + 69,
  PROXYAUTH_USED: 2097152 + 70,
  LASTONE: 70
};
var CURL_HTTP_VERSION = /* @__PURE__ */ ((CURL_HTTP_VERSION2) => {
  CURL_HTTP_VERSION2[CURL_HTTP_VERSION2["NONE"] = 0] = "NONE";
  CURL_HTTP_VERSION2[CURL_HTTP_VERSION2["V1_0"] = 1] = "V1_0";
  CURL_HTTP_VERSION2[CURL_HTTP_VERSION2["V1_1"] = 2] = "V1_1";
  CURL_HTTP_VERSION2[CURL_HTTP_VERSION2["V2_0"] = 3] = "V2_0";
  CURL_HTTP_VERSION2[CURL_HTTP_VERSION2["V2TLS"] = 4] = "V2TLS";
  CURL_HTTP_VERSION2[CURL_HTTP_VERSION2["V2_PRIOR_KNOWLEDGE"] = 5] = "V2_PRIOR_KNOWLEDGE";
  CURL_HTTP_VERSION2[CURL_HTTP_VERSION2["V3"] = 30] = "V3";
  CURL_HTTP_VERSION2[CURL_HTTP_VERSION2["V3ONLY"] = 31] = "V3ONLY";
  return CURL_HTTP_VERSION2;
})(CURL_HTTP_VERSION || {});
var CURLE = {
  OK: 0,
  UNSUPPORTED_PROTOCOL: 1,
  FAILED_INIT: 2,
  URL_MALFORMAT: 3,
  NOT_BUILT_IN: 4,
  COULDNT_RESOLVE_PROXY: 5,
  COULDNT_RESOLVE_HOST: 6,
  COULDNT_CONNECT: 7,
  WEIRD_SERVER_REPLY: 8,
  REMOTE_ACCESS_DENIED: 9,
  FTP_ACCEPT_FAILED: 10,
  FTP_WEIRD_PASS_REPLY: 11,
  FTP_ACCEPT_TIMEOUT: 12,
  FTP_WEIRD_PASV_REPLY: 13,
  FTP_WEIRD_227_FORMAT: 14,
  FTP_CANT_GET_HOST: 15,
  HTTP2: 16,
  FTP_COULDNT_SET_TYPE: 17,
  PARTIAL_FILE: 18,
  FTP_COULDNT_RETR_FILE: 19,
  OBSOLETE20: 20,
  QUOTE_ERROR: 21,
  HTTP_RETURNED_ERROR: 22,
  WRITE_ERROR: 23,
  OBSOLETE24: 24,
  UPLOAD_FAILED: 25,
  READ_ERROR: 26,
  OUT_OF_MEMORY: 27,
  OPERATION_TIMEDOUT: 28,
  FTP_PORT_FAILED: 30,
  FTP_COULDNT_USE_REST: 31,
  OBSOLETE32: 32,
  RANGE_ERROR: 33,
  HTTP_POST_ERROR: 34,
  SSL_CONNECT_ERROR: 35,
  BAD_DOWNLOAD_RESUME: 36,
  FILE_COULDNT_READ_FILE: 37,
  LDAP_CANNOT_BIND: 38,
  LDAP_SEARCH_FAILED: 39,
  OBSOLETE40: 40,
  FUNCTION_NOT_FOUND: 41,
  ABORTED_BY_CALLBACK: 42,
  BAD_FUNCTION_ARGUMENT: 43,
  OBSOLETE44: 44,
  INTERFACE_FAILED: 45,
  OBSOLETE46: 46,
  TOO_MANY_REDIRECTS: 47,
  UNKNOWN_OPTION: 48,
  TELNET_OPTION_SYNTAX: 49,
  OBSOLETE50: 50,
  PEER_FAILED_VERIFICATION: 51,
  GOT_NOTHING: 52,
  SSL_ENGINE_NOTFOUND: 53,
  SSL_ENGINE_SETFAILED: 54,
  SEND_ERROR: 55,
  RECV_ERROR: 56,
  OBSOLETE57: 57,
  SSL_CERTPROBLEM: 58,
  SSL_CIPHER: 59,
  SSL_CACERT: 60,
  BAD_CONTENT_ENCODING: 61,
  LDAP_INVALID_URL: 62,
  FILESIZE_EXCEEDED: 63,
  USE_SSL_FAILED: 64,
  SEND_FAIL_REWIND: 65,
  SSL_ENGINE_INITFAILED: 66,
  LOGIN_DENIED: 67,
  TFTP_NOTFOUND: 68,
  TFTP_PERM: 69,
  REMOTE_DISK_FULL: 70,
  TFTP_ILLEGAL: 71,
  TFTP_UNKNOWNID: 72,
  REMOTE_FILE_EXISTS: 73,
  TFTP_NOSUCHUSER: 74,
  CONV_FAILED: 75,
  CONV_REQD: 76,
  SSL_CACERT_BADFILE: 77,
  REMOTE_FILE_NOT_FOUND: 78,
  SSH: 79,
  SSL_SHUTDOWN_FAILED: 80,
  AGAIN: 81,
  SSL_CRL_BADFILE: 82,
  SSL_ISSUER_ERROR: 83,
  FTP_PRET_FAILED: 84,
  RTSP_CSEQ_ERROR: 85,
  RTSP_SESSION_ERROR: 86,
  FTP_BAD_FILE_LIST: 87,
  CHUNK_FAILED: 88,
  NO_CONNECTION_AVAILABLE: 89,
  SSL_PINNEDPUBKEYNOTMATCH: 90,
  SSL_INVALIDCERTSTATUS: 91,
  HTTP2_STREAM: 92,
  RECURSIVE_API_CALL: 93,
  AUTH_ERROR: 94,
  HTTP3: 95,
  QUIC_CONNECT_ERROR: 96,
  PROXY: 97,
  SSL_CLIENTCERT: 98,
  UNRECOVERABLE_POLL: 99
};
var CURL_SSLVERSION = /* @__PURE__ */ ((CURL_SSLVERSION2) => {
  CURL_SSLVERSION2[CURL_SSLVERSION2["DEFAULT"] = 0] = "DEFAULT";
  CURL_SSLVERSION2[CURL_SSLVERSION2["TLSv1"] = 1] = "TLSv1";
  CURL_SSLVERSION2[CURL_SSLVERSION2["SSLv2"] = 2] = "SSLv2";
  CURL_SSLVERSION2[CURL_SSLVERSION2["SSLv3"] = 3] = "SSLv3";
  CURL_SSLVERSION2[CURL_SSLVERSION2["TLSv1_0"] = 4] = "TLSv1_0";
  CURL_SSLVERSION2[CURL_SSLVERSION2["TLSv1_1"] = 5] = "TLSv1_1";
  CURL_SSLVERSION2[CURL_SSLVERSION2["TLSv1_2"] = 6] = "TLSv1_2";
  CURL_SSLVERSION2[CURL_SSLVERSION2["TLSv1_3"] = 7] = "TLSv1_3";
  CURL_SSLVERSION2[CURL_SSLVERSION2["MAX_DEFAULT"] = 65536] = "MAX_DEFAULT";
  return CURL_SSLVERSION2;
})(CURL_SSLVERSION || {});
var CURL_IP_RESOLVE = /* @__PURE__ */ ((CURL_IP_RESOLVE2) => {
  CURL_IP_RESOLVE2[CURL_IP_RESOLVE2["WHATEVER"] = 0] = "WHATEVER";
  CURL_IP_RESOLVE2[CURL_IP_RESOLVE2["V4"] = 1] = "V4";
  CURL_IP_RESOLVE2[CURL_IP_RESOLVE2["V6"] = 2] = "V6";
  return CURL_IP_RESOLVE2;
})(CURL_IP_RESOLVE || {});

// src/bindings/library.ts

var _path = require('path'); var _path2 = _interopRequireDefault(_path);
var _fs = require('fs'); var _fs2 = _interopRequireDefault(_fs);
var _os = require('os'); var _os2 = _interopRequireDefault(_os);
var CURL_VERSION = "1.0.0";
function getLibHome() {
  let libPath = _path2.default.join(__dirname, "..", "lib");
  if (!_fs2.default.existsSync(libPath)) {
    libPath = _path2.default.join(__dirname, "..", "..", "lib");
  }
  if (!_fs2.default.existsSync(libPath)) {
    throw new Error(`\u627E\u4E0D\u5230\u5E93\u76EE\u5F55: ${libPath}`);
  }
  return libPath;
}
function getPlatformName() {
  const platform = _os2.default.platform();
  if (platform === "win32") return "win32";
  if (platform === "darwin") return "macos";
  if (platform === "linux") {
    try {
      const lddOutput = __require("child_process").execSync("ldd --version 2>&1 || true").toString();
      if (/musl/.test(lddOutput)) {
        return "linux-musl";
      } else {
        return "linux-gnu";
      }
    } catch (e) {
      return "linux-gnu";
    }
  }
  throw new Error(`\u4E0D\u652F\u6301\u7684\u5E73\u53F0: ${platform}`);
}
function getLibraryPath() {
  const platform = getPlatformName();
  const arch = _os2.default.arch() === "x64" ? "x86_64" : _os2.default.arch() === "ia32" ? "i686" : _os2.default.arch() === "arm64" ? "aarch64" : _os2.default.arch();
  const libPath = _path2.default.join(getLibHome(), `${CURL_VERSION}-${platform}`);
  if (!_fs2.default.existsSync(libPath)) {
    throw new Error(`\u627E\u4E0D\u5230\u5E93\u76EE\u5F55: ${libPath}`);
  }
  let libName;
  if (platform === "win32") {
    libName = "libcurl.dll";
  } else if (platform === "macos") {
    libName = "libcurl-impersonate.4.dylib";
  } else {
    libName = "libcurl-impersonate.so";
  }
  const fullPath = _path2.default.join(libPath, libName);
  if (!_fs2.default.existsSync(fullPath)) {
    throw new Error(`\u627E\u4E0D\u5230\u5E93\u6587\u4EF6: ${fullPath}`);
  }
  return fullPath;
}
var libcurl = _koffi2.default.load(getLibraryPath());
var headerCallbackProto = _koffi2.default.proto("size_t HeaderCallbackProto(void*, size_t, size_t, void*)");
var progressCallbackProto = _koffi2.default.proto("int ProgressCallbackProto(void*, double, double, double, double)");
var curl = {
  // 初始化/清理函数
  curl_global_init: libcurl.func("curl_global_init", "int", ["long"]),
  curl_global_cleanup: libcurl.func("curl_global_cleanup", "void", []),
  // 句柄管理 - 使用void*替代pointer
  curl_easy_init: libcurl.func("curl_easy_init", "void*", []),
  curl_easy_cleanup: libcurl.func("curl_easy_cleanup", "void", ["void*"]),
  curl_easy_reset: libcurl.func("curl_easy_reset", "void", ["void*"]),
  curl_easy_duphandle: libcurl.func("curl_easy_duphandle", "void*", ["void*"]),
  // 选项和信息 - 使用正确的类型声明
  curl_easy_setopt_string: libcurl.func("curl_easy_setopt", "int", ["void*", "int", "string"]),
  curl_easy_setopt_long: libcurl.func("curl_easy_setopt", "int", ["void*", "int", "int64_t"]),
  curl_easy_setopt_pointer: libcurl.func("curl_easy_setopt", "int", ["void*", "int", "void*"]),
  curl_easy_setopt_callback: libcurl.func("curl_easy_setopt", "int", ["void*", "int", _koffi2.default.pointer(headerCallbackProto)]),
  // 添加通用 curl_easy_setopt 函数，用于处理回调函数
  curl_easy_setopt: libcurl.func("curl_easy_setopt", "int", ["void*", "int", "void*"]),
  // 修复 getinfo 函数的参数类型 - 使用 char** 来接收字符串指针
  curl_easy_getinfo_string: libcurl.func("curl_easy_getinfo", "int", ["void*", "int", "void*"]),
  curl_easy_getinfo_long: libcurl.func("curl_easy_getinfo", "int", ["void*", "int", "void*"]),
  curl_easy_getinfo_double: libcurl.func("curl_easy_getinfo", "int", ["void*", "int", "void*"]),
  curl_easy_getinfo_pointer: libcurl.func("curl_easy_getinfo", "int", ["void*", "int", "void*"]),
  // cdef.c中定义的额外函数
  curl_easy_impersonate: libcurl.func("curl_easy_impersonate", "int", ["void*", "string", "int"]),
  curl_easy_upkeep: libcurl.func("curl_easy_upkeep", "int", ["void*"]),
  // 执行和错误处理
  curl_easy_perform: libcurl.func("curl_easy_perform", "int", ["void*"]),
  curl_easy_strerror: libcurl.func("curl_easy_strerror", "string", ["int"]),
  // 链表管理 - 使用void*替代指向结构的指针
  curl_slist_append: libcurl.func("curl_slist_append", "void*", ["void*", "string"]),
  curl_slist_free_all: libcurl.func("curl_slist_free_all", "void", ["void*"]),
  // 版本信息
  curl_version: libcurl.func("curl_version", "string", []),
  // WebSocket支持
  curl_ws_recv: libcurl.func("curl_ws_recv", "int", ["void*", "void*", "int", "void*", "void*"]),
  curl_ws_send: libcurl.func("curl_ws_send", "int", ["void*", "void*", "int", "void*", "int", "unsigned int"]),
  // MIME支持
  curl_mime_init: libcurl.func("curl_mime_init", "void*", ["void*"]),
  curl_mime_addpart: libcurl.func("curl_mime_addpart", "void*", ["void*"]),
  curl_mime_name: libcurl.func("curl_mime_name", "int", ["void*", "string"]),
  curl_mime_data: libcurl.func("curl_mime_data", "int", ["void*", "string", "int"]),
  curl_mime_type: libcurl.func("curl_mime_type", "int", ["void*", "string"]),
  curl_mime_filename: libcurl.func("curl_mime_filename", "int", ["void*", "string"]),
  curl_mime_filedata: libcurl.func("curl_mime_filedata", "int", ["void*", "string"]),
  curl_mime_free: libcurl.func("curl_mime_free", "void", ["void*"])
};
curl.curl_global_init(3);
process.on("exit", () => {
  curl.curl_global_cleanup();
});

// src/bindings/memory.ts
var memory_exports = {};
__export(memory_exports, {
  bufferToPointer: () => bufferToPointer,
  createDoublePointerBuffer: () => createDoublePointerBuffer,
  createIntPointer: () => createIntPointer,
  createLongPointerBuffer: () => createLongPointerBuffer,
  createStringPointer: () => createStringPointer,
  createStringPointerBuffer: () => createStringPointerBuffer,
  getReference: () => getReference,
  pointerToBuffer: () => pointerToBuffer,
  releaseReference: () => releaseReference,
  saveReference: () => saveReference
});

var _buffer = require('buffer');

// src/utils/logger.ts
var LogLevel = /* @__PURE__ */ ((LogLevel2) => {
  LogLevel2[LogLevel2["ERROR"] = 0] = "ERROR";
  LogLevel2[LogLevel2["WARN"] = 1] = "WARN";
  LogLevel2[LogLevel2["INFO"] = 2] = "INFO";
  LogLevel2[LogLevel2["DEBUG"] = 3] = "DEBUG";
  return LogLevel2;
})(LogLevel || {});
var Logger = class {
  // 默认只显示错误
  constructor() {
    this.level = 0 /* ERROR */;
    const envLevel = _optionalChain([process, 'access', _2 => _2.env, 'access', _3 => _3.KOFFI_CURL_LOG_LEVEL, 'optionalAccess', _4 => _4.toUpperCase, 'call', _5 => _5()]);
    switch (envLevel) {
      case "ERROR":
        this.level = 0 /* ERROR */;
        break;
      case "WARN":
        this.level = 1 /* WARN */;
        break;
      case "INFO":
        this.level = 2 /* INFO */;
        break;
      case "DEBUG":
        this.level = 3 /* DEBUG */;
        break;
      default:
        if (process.env.NODE_ENV === "development" || process.env.DEBUG === "1" || process.env.DEBUG === "koffi-curl") {
          this.level = 3 /* DEBUG */;
        }
    }
  }
  /**
   * 设置日志级别
   */
  setLevel(level) {
    this.level = level;
  }
  /**
   * 获取当前日志级别
   */
  getLevel() {
    return this.level;
  }
  /**
   * 错误日志
   */
  error(...args) {
    if (this.level >= 0 /* ERROR */) {
      console.error("[ERROR]", ...args);
    }
  }
  /**
   * 警告日志
   */
  warn(...args) {
    if (this.level >= 1 /* WARN */) {
      console.warn("[WARN]", ...args);
    }
  }
  /**
   * 信息日志
   */
  info(...args) {
    if (this.level >= 2 /* INFO */) {
      console.log("[INFO]", ...args);
    }
  }
  /**
   * 调试日志
   */
  debug(...args) {
    if (this.level >= 3 /* DEBUG */) {
      console.log("[DEBUG]", ...args);
    }
  }
  /**
   * 检查是否启用了调试模式
   */
  isDebugEnabled() {
    return this.level >= 3 /* DEBUG */;
  }
  /**
   * 检查是否启用了警告模式
   */
  isWarnEnabled() {
    return this.level >= 1 /* WARN */;
  }
};
var logger = new Logger();
var warn = (...args) => logger.warn(...args);
var debug = (...args) => logger.debug(...args);

// src/bindings/memory.ts
var references = /* @__PURE__ */ new Map();
var nextRefId = 1;
function saveReference(obj) {
  const id = nextRefId++;
  references.set(id, obj);
  return id;
}
function getReference(id) {
  return references.get(id);
}
function releaseReference(id) {
  references.delete(id);
}
function bufferToPointer(buffer) {
  return _koffi2.default.as(buffer, _koffi2.default.pointer("void"));
}
function pointerToBuffer(ptr, size) {
  const buffer = _buffer.Buffer.alloc(size);
  try {
    for (let i = 0; i < size; i++) {
      try {
        buffer[i] = _koffi2.default.decode(ptr, i, "uint8_t");
      } catch (e) {
        buffer[i] = 0;
      }
    }
  } catch (e) {
    console.error("\u8BFB\u53D6\u6307\u9488\u5185\u5B58\u5931\u8D25:", e);
  }
  return buffer;
}
function createIntPointer(value = 0) {
  const buffer = _buffer.Buffer.alloc(4);
  buffer.writeInt32LE(value, 0);
  return {
    ptr: bufferToPointer(buffer),
    value: () => buffer.readInt32LE(0),
    free: () => {
    }
    // Buffer 会被 GC 处理
  };
}
function createStringPointer(str) {
  return _koffi2.default.as(str, _koffi2.default.pointer("char"));
}
function createStringPointerBuffer() {
  const buffer = _buffer.Buffer.alloc(8);
  buffer.fill(0);
  return {
    buffer,
    ptr: bufferToPointer(buffer),
    readString: () => {
      try {
        const ptrValue = buffer.readBigUInt64LE(0);
        if (ptrValue === BigInt(0)) {
          return "";
        }
        if (ptrValue < BigInt(4096)) {
          debug("\u68C0\u6D4B\u5230\u53EF\u80FD\u65E0\u6548\u7684\u6307\u9488\u5730\u5740:", ptrValue.toString(16));
          return "";
        }
        try {
          const result = _koffi2.default.decode(_koffi2.default.as(ptrValue, "void*"), "string");
          return result || "";
        } catch (decodeError) {
          debug("\u89E3\u7801\u5B57\u7B26\u4E32\u5931\u8D25\uFF0C\u8FD4\u56DE\u7A7A\u5B57\u7B26\u4E32:", decodeError.message);
          return "";
        }
      } catch (e) {
        debug("\u8BFB\u53D6\u5B57\u7B26\u4E32\u6307\u9488\u5931\u8D25:", e.message);
        return "";
      }
    }
  };
}
function createLongPointerBuffer() {
  const buffer = _buffer.Buffer.alloc(8);
  buffer.fill(0);
  return {
    buffer,
    ptr: bufferToPointer(buffer),
    readLong: () => {
      return Number(buffer.readBigInt64LE(0));
    }
  };
}
function createDoublePointerBuffer() {
  const buffer = _buffer.Buffer.alloc(8);
  buffer.fill(0);
  return {
    buffer,
    ptr: bufferToPointer(buffer),
    readDouble: () => {
      return buffer.readDoubleLE(0);
    }
  };
}

// src/bindings/callbacks.ts
var callbacks_exports = {};
__export(callbacks_exports, {
  cleanupCallbacks: () => cleanupCallbacks,
  createBufferCallback: () => createBufferCallback,
  createProgressCallback: () => createProgressCallback,
  releaseCallback: () => releaseCallback
});

var REGISTERED_CALLBACKS = /* @__PURE__ */ new Map();
var nextCallbackId = 1;
function createBufferCallback(callback) {
  const id = saveReference(callback);
  const writeCallback = function(ptr, size, nmemb, userdata) {
    try {
      const totalSize = size * nmemb;
      if (totalSize === 0) return 0;
      const data = pointerToBuffer(ptr, totalSize);
      const jsCallback = getReference(id);
      return jsCallback(data);
    } catch (err) {
      debug("Write callback \u9519\u8BEF:", err);
      return 0;
    }
  };
  const callbackId = nextCallbackId++;
  const functionPointer = _koffi2.default.register(writeCallback, _koffi2.default.pointer(headerCallbackProto));
  REGISTERED_CALLBACKS.set(callbackId, functionPointer);
  return { callback: functionPointer, id: callbackId };
}
function createProgressCallback(callback) {
  const id = saveReference(callback);
  const progressCallback = function(clientp, dltotal, dlnow, ultotal, ulnow) {
    try {
      const jsCallback = getReference(id);
      return jsCallback(dltotal, dlnow, ultotal, ulnow);
    } catch (err) {
      debug("Progress callback \u9519\u8BEF:", err);
      return 0;
    }
  };
  const callbackId = nextCallbackId++;
  const functionPointer = _koffi2.default.register(progressCallback, _koffi2.default.pointer(progressCallbackProto));
  REGISTERED_CALLBACKS.set(callbackId, functionPointer);
  return { callback: functionPointer, id: callbackId };
}
function releaseCallback(callbackId) {
  _koffi2.default.unregister(REGISTERED_CALLBACKS.get(callbackId));
  releaseReference(callbackId);
  REGISTERED_CALLBACKS.delete(callbackId);
}
function cleanupCallbacks() {
  REGISTERED_CALLBACKS.clear();
}
process.on("exit", () => {
  cleanupCallbacks();
});

// src/bindings/index.ts
var constants = constants_exports;
var memory = memory_exports;
var callbacks = callbacks_exports;
var libcurlVersion = () => curl.curl_version();

// src/core/curl.ts


// src/bindings/tls.ts
var TLS_VERSION_MAP = {
  769: 4 /* TLSv1_0 */,
  // 769
  770: 5 /* TLSv1_1 */,
  // 770  
  771: 6 /* TLSv1_2 */,
  // 771
  772: 7 /* TLSv1_3 */
  // 772
};
var TLS_CIPHER_NAME_MAP = {
  10: "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
  47: "TLS_RSA_WITH_AES_128_CBC_SHA",
  51: "TLS_DHE_RSA_WITH_AES_128_CBC_SHA",
  53: "TLS_RSA_WITH_AES_256_CBC_SHA",
  57: "TLS_DHE_RSA_WITH_AES_256_CBC_SHA",
  60: "TLS_RSA_WITH_AES_128_CBC_SHA256",
  61: "TLS_RSA_WITH_AES_256_CBC_SHA256",
  103: "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256",
  107: "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256",
  140: "TLS_PSK_WITH_AES_128_CBC_SHA",
  141: "TLS_PSK_WITH_AES_256_CBC_SHA",
  156: "TLS_RSA_WITH_AES_128_GCM_SHA256",
  157: "TLS_RSA_WITH_AES_256_GCM_SHA384",
  158: "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256",
  159: "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384",
  4865: "TLS_AES_128_GCM_SHA256",
  4866: "TLS_AES_256_GCM_SHA384",
  4867: "TLS_CHACHA20_POLY1305_SHA256",
  49160: "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA",
  49161: "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
  49162: "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
  49170: "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
  49171: "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
  49172: "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
  49187: "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
  49188: "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384",
  49191: "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
  49192: "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
  49195: "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
  49196: "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
  49199: "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
  49200: "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
  49205: "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA",
  49206: "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA",
  52392: "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256",
  52393: "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256",
  52396: "TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256"
};
var TLS_EC_CURVES_MAP = {
  19: "P-192",
  21: "P-224",
  23: "P-256",
  24: "P-384",
  25: "P-521",
  29: "X25519",
  4588: "X25519MLKEM768",
  25497: "X25519Kyber768Draft00"
};
var DEFAULT_ENABLED_EXTENSIONS = /* @__PURE__ */ new Set([0, 51, 13, 43, 65281, 23, 10, 45, 35, 11, 16]);

// src/core/curl.ts
var Curl = class _Curl {
  /**
   * 创建新的 Curl 实例
   */
  constructor() {
    // 回调引用，用于后续释放
    this.callbackRefs = {};
    // 链表引用
    this.slists = {};
    this.nextSlistId = 1;
    this.handle = curl.curl_easy_init();
    if (!this.handle) {
      throw new Error("\u65E0\u6CD5\u521D\u59CB\u5316 CURL \u53E5\u67C4");
    }
  }
  /**
   * 关闭并清理 CURL 句柄
   */
  close() {
    if (this.handle) {
      Object.values(this.slists).forEach((slist) => {
        curl.curl_slist_free_all(slist);
      });
      this.slists = {};
      Object.values(this.callbackRefs).forEach((id) => {
        callbacks.releaseCallback(id);
      });
      this.callbackRefs = {};
      curl.curl_easy_cleanup(this.handle);
      this.handle = null;
    }
  }
  /**
   * 重置 CURL 句柄为初始状态
   */
  reset() {
    if (!this.handle) throw new Error("CURL \u53E5\u67C4\u5DF2\u5173\u95ED");
    curl.curl_easy_reset(this.handle);
    Object.values(this.slists).forEach((slist) => {
      curl.curl_slist_free_all(slist);
    });
    this.slists = {};
    Object.values(this.callbackRefs).forEach((id) => {
      callbacks.releaseCallback(id);
    });
    this.callbackRefs = {};
  }
  /**
   * 设置 CURL 选项
   * @param option CURLOPT 选项
   * @param value 选项值
   */
  setopt(option, value) {
    if (!this.handle) throw new Error("CURL \u53E5\u67C4\u5DF2\u5173\u95ED");
    try {
      if (typeof value === "number") {
        const numValue = Number(value);
        const result = curl.curl_easy_setopt_long(this.handle, option, numValue);
        if (result !== 0) {
          throw new Error(`\u8BBE\u7F6E\u6570\u503C\u9009\u9879\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
        }
      } else if (typeof value === "string") {
        const strValue = String(value);
        const result = curl.curl_easy_setopt_string(this.handle, option, strValue);
        if (result !== 0) {
          throw new Error(`\u8BBE\u7F6E\u5B57\u7B26\u4E32\u9009\u9879\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
        }
      } else if (typeof value === "boolean") {
        const numValue = value ? 1 : 0;
        const result = curl.curl_easy_setopt_long(this.handle, option, numValue);
        if (result !== 0) {
          throw new Error(`\u8BBE\u7F6E\u5E03\u5C14\u9009\u9879\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
        }
      } else if (typeof value === "function") {
        const callbackType = option;
        if (this.callbackRefs[callbackType]) {
          callbacks.releaseCallback(this.callbackRefs[callbackType]);
          delete this.callbackRefs[callbackType];
        }
        const cb = callbacks.createBufferCallback(value);
        let result = curl.curl_easy_setopt_callback(this.handle, option, cb.callback);
        if (result !== 0) {
          throw new Error(`\u8BBE\u7F6E\u56DE\u8C03\u9009\u9879\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
        }
        this.callbackRefs[callbackType] = cb.id;
      } else if (Array.isArray(value)) {
        let slist = null;
        for (const header of value) {
          const headerStr = header.toString();
          slist = curl.curl_slist_append(slist, headerStr);
        }
        const id = this.nextSlistId++;
        if (slist) {
          const result = curl.curl_easy_setopt_pointer(this.handle, option, slist);
          if (result !== 0) {
            throw new Error(`\u8BBE\u7F6E\u94FE\u8868\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
          }
          this.slists[id] = slist;
        }
      } else if (value instanceof _buffer.Buffer) {
        const dataPtr = memory.bufferToPointer(value);
        const result = curl.curl_easy_setopt_pointer(this.handle, option, dataPtr);
        if (result !== 0) {
          throw new Error(`\u8BBE\u7F6E Buffer \u9009\u9879\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
        }
      } else {
        const result = curl.curl_easy_setopt_pointer(this.handle, option, value);
        if (result !== 0) {
          throw new Error(`\u8BBE\u7F6E\u9009\u9879\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
        }
      }
    } catch (err) {
      console.error(err);
      const optionName = _optionalChain([Object, 'access', _6 => _6.entries, 'call', _7 => _7(constants.CURLOPT), 'access', _8 => _8.find, 'call', _9 => _9(([_, val]) => val === option), 'optionalAccess', _10 => _10[0]]) || option;
      throw new Error(`\u8BBE\u7F6E\u9009\u9879 ${optionName} \u5931\u8D25: ${err.message}`);
    }
  }
  /**
   * 执行 HTTP 请求
   * @returns 错误码
   */
  perform() {
    if (!this.handle) throw new Error("CURL \u53E5\u67C4\u5DF2\u5173\u95ED");
    return curl.curl_easy_perform(this.handle);
  }
  impersonate(impersonate, isDefaultHeader = true) {
    return curl.curl_easy_impersonate(this.handle, impersonate, isDefaultHeader ? 1 : 0);
  }
  /**
   * 获取 CURL 信息
   * @param info 信息类型
   * @returns 信息值
   */
  getinfo(info2) {
    if (!this.handle) throw new Error("CURL \u53E5\u67C4\u5DF2\u5173\u95ED");
    const infoType = info2 & 15728640;
    try {
      switch (infoType) {
        // 字符串类型
        case 1048576: {
          const { ptr, readString } = memory.createStringPointerBuffer();
          const result = curl.curl_easy_getinfo_string(this.handle, info2, ptr);
          if (result !== 0) {
            debug(`\u83B7\u53D6\u5B57\u7B26\u4E32\u4FE1\u606F\u5931\u8D25 (${info2}): ${curl.curl_easy_strerror(result)}`);
            return "";
          }
          const stringResult = readString();
          return stringResult;
        }
        // 长整数类型
        case 2097152: {
          const { ptr, readLong } = memory.createLongPointerBuffer();
          const result = curl.curl_easy_getinfo_long(this.handle, info2, ptr);
          if (result !== 0) {
            throw new Error(`\u83B7\u53D6\u4FE1\u606F\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
          }
          return readLong();
        }
        // 双精度浮点型
        case 3145728: {
          const { ptr, readDouble } = memory.createDoublePointerBuffer();
          const result = curl.curl_easy_getinfo_double(this.handle, info2, ptr);
          if (result !== 0) {
            throw new Error(`\u83B7\u53D6\u4FE1\u606F\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
          }
          return readDouble();
        }
        // 指针类型
        case 4194304: {
          const buffer = _buffer.Buffer.alloc(8);
          const ptr = memory.bufferToPointer(buffer);
          const result = curl.curl_easy_getinfo_pointer(this.handle, info2, ptr);
          if (result !== 0) {
            throw new Error(`\u83B7\u53D6\u4FE1\u606F\u5931\u8D25: ${curl.curl_easy_strerror(result)}`);
          }
          const ptrValue = buffer.readBigUInt64LE(0);
          return ptrValue === BigInt(0) ? null : _koffi2.default.as(ptrValue, "void*");
        }
        // 不支持的类型
        default:
          throw new Error(`\u4E0D\u652F\u6301\u7684\u4FE1\u606F\u7C7B\u578B: ${info2.toString(16)}`);
      }
    } catch (err) {
      if ((info2 & 15728640) === 1048576) {
        debug(`\u83B7\u53D6\u5B57\u7B26\u4E32\u4FE1\u606F\u5931\u8D25\uFF0C\u8FD4\u56DE\u7A7A\u5B57\u7B26\u4E32: ${err.message}`);
        return "";
      }
      const infoName = _optionalChain([Object, 'access', _11 => _11.entries, 'call', _12 => _12(constants.CURLINFO), 'access', _13 => _13.find, 'call', _14 => _14(([_, val]) => val === info2), 'optionalAccess', _15 => _15[0]]) || info2.toString();
      throw new Error(`\u83B7\u53D6\u4FE1\u606F ${infoName} \u5931\u8D25: ${err.message}`);
    }
  }
  setHeaders(headers) {
    const headerList = Object.entries(headers).map(([key, value]) => `${key}: ${value}`);
    if (headerList.length === 0) return;
    this.setopt(constants.CURLOPT.HTTPHEADER, headerList);
  }
  upkeep() {
    curl.curl_easy_upkeep(this.handle);
  }
  static version() {
    return curl.curl_version();
  }
  /**
   * 复制当前 CURL 句柄
   * @returns 新的 Curl 实例
   */
  duplicate() {
    if (!this.handle) throw new Error("CURL \u53E5\u67C4\u5DF2\u5173\u95ED");
    const newCurl = new _Curl();
    curl.curl_easy_cleanup(newCurl.handle);
    newCurl.handle = curl.curl_easy_duphandle(this.handle);
    if (!newCurl.handle) {
      throw new Error("\u65E0\u6CD5\u590D\u5236 CURL \u53E5\u67C4");
    }
    return newCurl;
  }
  /**
   * 返回最后一个错误的描述
   * @param code 错误码
   * @returns 错误描述
   */
  static strerror(code) {
    return curl.curl_easy_strerror(code);
  }
  /**
   * 设置 JA3 指纹
   * @param ja3 JA3 指纹字符串
   * @param permute 是否允许扩展乱序
   */
  setJa3Fingerprint(ja3, permute = false) {
    if (!this.handle) throw new Error("CURL \u53E5\u67C4\u5DF2\u5173\u95ED");
    const parts = ja3.split(",");
    if (parts.length !== 5) {
      throw new Error("\u65E0\u6548\u7684 JA3 \u6307\u7EB9\u683C\u5F0F\uFF0C\u5E94\u4E3A 5 \u90E8\u5206\u7528\u9017\u53F7\u5206\u9694");
    }
    const [tlsVersion, ciphers, extensions, curves, curveFormats] = parts;
    const curlTlsVersion = TLS_VERSION_MAP[parseInt(tlsVersion)];
    if (!curlTlsVersion) {
      throw new Error(`\u4E0D\u652F\u6301\u7684 TLS \u7248\u672C: ${tlsVersion}`);
    }
    this.setopt(constants.CURLOPT.SSLVERSION, curlTlsVersion | constants.CURL_SSLVERSION.MAX_DEFAULT);
    if (curlTlsVersion !== constants.CURL_SSLVERSION.TLSv1_2) {
      warn("\u76EE\u524D\u53EA\u6709 TLS v1.2 \u5B8C\u5168\u652F\u6301 JA3 \u6307\u7EB9");
    }
    const cipherNames = [];
    for (const cipher of ciphers.split("-")) {
      const cipherId = parseInt(cipher);
      const cipherName = TLS_CIPHER_NAME_MAP[cipherId];
      if (!cipherName) {
        throw new Error(`\u627E\u4E0D\u5230\u5BC6\u7801\u5957\u4EF6: ${cipher} (0x${cipherId.toString(16)})`);
      }
      cipherNames.push(cipherName);
    }
    this.setopt(constants.CURLOPT.SSL_CIPHER_LIST, cipherNames.join(":"));
    let processedExtensions = extensions;
    if (extensions.endsWith("-21")) {
      processedExtensions = extensions.slice(0, -3);
      warn("\u5728 JA3 \u5B57\u7B26\u4E32\u4E2D\u53D1\u73B0 Padding(21) \u6269\u5C55\uFF0C\u662F\u5426\u6DFB\u52A0\u5E94\u7531 SSL \u5F15\u64CE\u7BA1\u7406");
    }
    const extensionIds = new Set(processedExtensions.split("-").map((e) => parseInt(e)));
    this.toggleExtensionsByIds(extensionIds);
    if (!permute) {
      this.setopt(constants.CURLOPT.TLS_EXTENSION_ORDER, processedExtensions);
    }
    const curveNames = [];
    for (const curve of curves.split("-")) {
      const curveId = parseInt(curve);
      const curveName = TLS_EC_CURVES_MAP[curveId];
      if (!curveName) {
        throw new Error(`\u627E\u4E0D\u5230\u692D\u5706\u66F2\u7EBF: ${curve}`);
      }
      curveNames.push(curveName);
    }
    this.setopt(constants.CURLOPT.SSL_EC_CURVES, curveNames.join(":"));
    if (parseInt(curveFormats) !== 0) {
      throw new Error("\u53EA\u652F\u6301 curve_formats == 0");
    }
  }
  /**
   * 设置 Akamai 指纹
   * @param akamai Akamai 指纹字符串
   */
  setAkamaiFingerprint(akamai) {
    if (!this.handle) throw new Error("CURL \u53E5\u67C4\u5DF2\u5173\u95ED");
    const parts = akamai.split("|");
    if (parts.length !== 4) {
      throw new Error("\u65E0\u6548\u7684 Akamai \u6307\u7EB9\u683C\u5F0F\uFF0C\u5E94\u4E3A 4 \u90E8\u5206\u7528\u7AD6\u7EBF\u5206\u9694");
    }
    let [settings, windowUpdate, streams, headerOrder] = parts;
    settings = settings.replace(/,/g, ";");
    this.setopt(constants.CURLOPT.HTTP_VERSION, constants.CURL_HTTP_VERSION.V2_0);
    this.setopt(constants.CURLOPT.HTTP2_SETTINGS, settings);
    this.setopt(constants.CURLOPT.HTTP2_WINDOW_UPDATE, parseInt(windowUpdate));
    if (streams !== "0") {
      this.setopt(constants.CURLOPT.HTTP2_STREAMS, streams);
    }
    this.setopt(constants.CURLOPT.HTTP2_PSEUDO_HEADERS_ORDER, headerOrder.replace(/,/g, ""));
  }
  /**
   * 根据扩展 ID 切换扩展
   * @param extensionIds 扩展 ID 集合
   */
  toggleExtensionsByIds(extensionIds) {
    const toEnableIds = new Set([...extensionIds].filter((id) => !DEFAULT_ENABLED_EXTENSIONS.has(id)));
    for (const extId of toEnableIds) {
      this.toggleExtension(extId, true);
    }
    const toDisableIds = new Set([...DEFAULT_ENABLED_EXTENSIONS].filter((id) => !extensionIds.has(id)));
    for (const extId of toDisableIds) {
      this.toggleExtension(extId, false);
    }
  }
  /**
   * 切换单个扩展
   * @param extensionId 扩展 ID
   * @param enable 是否启用
   */
  toggleExtension(extensionId, enable) {
    switch (extensionId) {
      // ECH
      case 65037:
        this.setopt(constants.CURLOPT.ECH, enable ? "grease" : "");
        break;
      // 证书压缩
      case 27:
        if (enable) {
          warn("\u8BC1\u4E66\u538B\u7F29\u8BBE\u7F6E\u4E3A brotli\uFF0C\u5EFA\u8BAE\u660E\u786E\u6307\u5B9A\u4F7F\u7528 zlib \u6216 brotli");
          this.setopt(constants.CURLOPT.SSL_CERT_COMPRESSION, "brotli");
        } else {
          this.setopt(constants.CURLOPT.SSL_CERT_COMPRESSION, "");
        }
        break;
      // ALPS: 应用设置
      case 17513:
        this.setopt(constants.CURLOPT.SSL_ENABLE_ALPS, enable ? 1 : 0);
        break;
      case 17613:
        this.setopt(constants.CURLOPT.SSL_ENABLE_ALPS, enable ? 1 : 0);
        this.setopt(constants.CURLOPT.TLS_USE_NEW_ALPS_CODEPOINT, enable ? 1 : 0);
        break;
      // server_name
      case 0:
        throw new Error("server_name(0) \u6269\u5C55\u4E0D\u592A\u53EF\u80FD\u88AB\u66F4\u6539");
      // ALPN
      case 16:
        this.setopt(constants.CURLOPT.SSL_ENABLE_ALPN, enable ? 1 : 0);
        break;
      // status_request
      case 5:
        if (enable) {
          this.setopt(constants.CURLOPT.TLS_STATUS_REQUEST, 1);
        }
        break;
      // signed_certificate_timestamps
      case 18:
        if (enable) {
          this.setopt(constants.CURLOPT.TLS_SIGNED_CERT_TIMESTAMPS, 1);
        }
        break;
      // session_ticket
      case 35:
        this.setopt(constants.CURLOPT.SSL_ENABLE_TICKET, enable ? 1 : 0);
        break;
      // padding
      case 21:
        break;
      default:
        throw new Error(`\u6269\u5C55 ${extensionId} \u6682\u65F6\u65E0\u6CD5\u5207\u6362\uFF0C\u53EF\u80FD\u4F1A\u5728\u540E\u7EED\u7248\u672C\u4E2D\u66F4\u65B0`);
    }
  }
  /**
   * 设置额外的指纹参数
   * @param extraFp 额外指纹配置
   */
  setExtraFingerprint(extraFp) {
    if (!this.handle) throw new Error("CURL \u53E5\u67C4\u5DF2\u5173\u95ED");
    if (extraFp.tlsSignatureAlgorithms) {
      this.setopt(constants.CURLOPT.SSL_SIG_HASH_ALGS, extraFp.tlsSignatureAlgorithms.join(","));
    }
    if (extraFp.tlsMinVersion !== void 0) {
      this.setopt(constants.CURLOPT.SSLVERSION, extraFp.tlsMinVersion | constants.CURL_SSLVERSION.MAX_DEFAULT);
    }
    if (extraFp.tlsGrease !== void 0) {
      this.setopt(constants.CURLOPT.TLS_GREASE, extraFp.tlsGrease ? 1 : 0);
    }
    if (extraFp.tlsPermuteExtensions !== void 0) {
      this.setopt(constants.CURLOPT.SSL_PERMUTE_EXTENSIONS, extraFp.tlsPermuteExtensions ? 1 : 0);
    }
    if (extraFp.tlsCertCompression) {
      this.setopt(constants.CURLOPT.SSL_CERT_COMPRESSION, extraFp.tlsCertCompression);
    }
    if (extraFp.http2StreamWeight !== void 0) {
      this.setopt(constants.CURLOPT.STREAM_WEIGHT, extraFp.http2StreamWeight);
    }
    if (extraFp.http2StreamExclusive !== void 0) {
      this.setopt(constants.CURLOPT.STREAM_EXCLUSIVE, extraFp.http2StreamExclusive);
    }
  }
};

// src/core/request.ts
var request_exports = {};
__export(request_exports, {
  ResponseHeader: () => ResponseHeader,
  default: () => request_default,
  delete: () => apiDelete,
  get: () => get,
  patch: () => patch,
  post: () => post,
  put: () => put,
  request: () => request
});




var _zlib = require('zlib'); var _zlib2 = _interopRequireDefault(_zlib);
var ResponseHeader = class {
  constructor() {
    this.header = {};
  }
  set(key, value) {
    key = key.toLowerCase();
    if (!this.header[key]) {
      this.header[key] = [];
    }
    this.header[key].push(value);
  }
  get(key) {
    key = key.toLowerCase();
    if (!this.header[key]) {
      return void 0;
    }
    return _optionalChain([this, 'access', _16 => _16.header, 'access', _17 => _17[key], 'optionalAccess', _18 => _18[0]]);
  }
  getAll(key) {
    key = key.toLowerCase();
    if (!this.header[key]) {
      return void 0;
    }
    return this.header[key];
  }
  toString() {
    return Object.entries(this.header).map(([key, values]) => `${key}: ${Array.isArray(values) ? values.join(", ") : values}`).join("\r\n");
  }
};
var defaultOptions = {
  method: "GET",
  timeout: 3e4,
  followRedirects: true,
  maxRedirects: 5,
  verifySsl: true,
  acceptEncoding: "gzip, deflate, br"
};
function buildUrl(baseUrl, params) {
  if (!params) return baseUrl;
  const url = new URL(baseUrl);
  Object.entries(params).forEach(([key, value]) => {
    url.searchParams.set(key, String(value));
  });
  return url.toString();
}
function getCertPath() {
  const projectCaPath = _path2.default.join(getLibHome(), "cacert.pem");
  if (_fs2.default.existsSync(projectCaPath)) {
    return projectCaPath;
  } else if (_os2.default.platform() === "win32") {
    debug("Windows\u7CFB\u7EDF\uFF0C\u4F7F\u7528libcurl-impersonate\u5185\u7F6E\u8BC1\u4E66");
  } else if (_os2.default.platform() === "darwin") {
    const macPaths = [
      "/usr/local/etc/openssl/cert.pem",
      "/etc/ssl/cert.pem",
      "/usr/local/etc/openssl@1.1/cert.pem"
    ];
    return macPaths.find((p) => _fs2.default.existsSync(p));
  } else {
    const linuxPaths = [
      "/etc/ssl/certs/ca-certificates.crt",
      "/etc/pki/tls/certs/ca-bundle.crt",
      "/usr/share/ssl/certs/ca-bundle.crt",
      "/usr/local/share/certs/ca-root-nss.crt"
    ];
    return linuxPaths.find((p) => _fs2.default.existsSync(p));
  }
}
function parseHeaders(headerBuffer) {
  const headers = new ResponseHeader();
  const headerString = headerBuffer.toString("utf8");
  const lines = headerString.split("\r\n");
  for (const line of lines) {
    const colonIndex = line.indexOf(":");
    if (colonIndex > 0) {
      const key = line.substring(0, colonIndex).trim().toLowerCase();
      const value = line.substring(colonIndex + 1).trim();
      headers.set(key, value);
    }
  }
  return headers;
}
function decompressResponse(responseBuffer, headers) {
  const encoding = _nullishCoalesce(headers.get("content-encoding"), () => ( ""));
  if (!encoding) {
    return responseBuffer.toString("utf8");
  }
  try {
    switch (encoding.toLowerCase()) {
      case "gzip":
        return _zlib2.default.gunzipSync(responseBuffer).toString("utf8");
      case "deflate":
        return _zlib2.default.inflateSync(responseBuffer).toString("utf8");
      case "br":
        return _zlib2.default.brotliDecompressSync(responseBuffer).toString("utf8");
      default:
        debug(`\u672A\u77E5\u7684\u7F16\u7801\u683C\u5F0F: ${encoding}\uFF0C\u4F7F\u7528\u539F\u59CB\u6570\u636E`);
        return responseBuffer.toString("utf8");
    }
  } catch (error) {
    warn(`\u89E3\u538B\u7F29\u5931\u8D25 (${encoding}): ${error.message}\uFF0C\u4F7F\u7528\u539F\u59CB\u6570\u636E`);
    return responseBuffer.toString("utf8");
  }
}
function parseReponseData(body, headers) {
  const contentType = headers.get("content-type") || "";
  if (contentType.includes("application/json")) {
    try {
      return JSON.parse(body);
    } catch (e) {
      warn("JSON \u89E3\u6790\u5931\u8D25:", e);
      return body;
    }
  } else if (contentType.includes("application/x-www-form-urlencoded")) {
    const params = new URLSearchParams(body);
    const result = {};
    for (const [key, value] of params.entries()) {
      result[key] = value;
    }
    return result;
  }
  return body;
}
function getStatusText(status) {
  const statusTexts = {
    200: "OK",
    201: "Created",
    204: "No Content",
    400: "Bad Request",
    401: "Unauthorized",
    403: "Forbidden",
    404: "Not Found",
    500: "Internal Server Error"
  };
  return statusTexts[status] || "Unknown";
}
async function executeRequest(curl2) {
  return new Promise((resolve, reject) => {
    const responseDataBuffers = [];
    const responseHeaderBuffers = [];
    curl2.setopt(constants.CURLOPT.WRITEFUNCTION, (data) => {
      responseDataBuffers.push(data);
      return data.length;
    });
    curl2.setopt(constants.CURLOPT.HEADERFUNCTION, (data) => {
      responseHeaderBuffers.push(data);
      return data.length;
    });
    setImmediate(() => {
      try {
        const startTime = Date.now();
        const resultCode = curl2.perform();
        if (resultCode !== 0) {
          reject(new Error(`CURL \u9519\u8BEF (${resultCode}): ${Curl.strerror(resultCode)}`));
          return;
        }
        const status = curl2.getinfo(constants.CURLINFO.RESPONSE_CODE);
        let finalUrl = "";
        let redirectCount = 0;
        try {
          finalUrl = curl2.getinfo(constants.CURLINFO.EFFECTIVE_URL) || "";
        } catch (e) {
          debug("\u65E0\u6CD5\u83B7\u53D6\u6709\u6548URL\uFF0C\u4F7F\u7528\u7A7A\u5B57\u7B26\u4E32");
          finalUrl = "";
        }
        try {
          redirectCount = curl2.getinfo(constants.CURLINFO.REDIRECT_COUNT) || 0;
        } catch (e) {
          debug("\u65E0\u6CD5\u83B7\u53D6\u91CD\u5B9A\u5411\u6B21\u6570\uFF0C\u4F7F\u75280");
          redirectCount = 0;
        }
        const responseHeaderBuffer = _buffer.Buffer.concat(responseHeaderBuffers);
        const responseDataBuffer = _buffer.Buffer.concat(responseDataBuffers);
        const headers = parseHeaders(responseHeaderBuffer);
        const statusText = getStatusText(status);
        const decompressedData = decompressResponse(responseDataBuffer, headers);
        resolve({
          status,
          statusText,
          headers,
          data: parseReponseData(decompressedData, headers),
          buffer: responseDataBuffer,
          url: finalUrl,
          redirectCount,
          duration: Date.now() - startTime
        });
      } catch (error) {
        reject(error);
      }
    });
  });
}
async function request(options) {
  const opts = { ...defaultOptions, ...options };
  let currentUrl = buildUrl(opts.url, opts.params);
  let redirectCount = 0;
  const maxRedirects = _nullishCoalesce(opts.maxRedirects, () => ( 5));
  const maxRetries = _nullishCoalesce(opts.retryCount, () => ( 0));
  let finalResponseUrl = currentUrl;
  const curl2 = new Curl();
  try {
    for (let retryAttempt = 0; retryAttempt <= maxRetries; retryAttempt++) {
      redirectCount = 0;
      currentUrl = buildUrl(opts.url, opts.params);
      try {
        while (redirectCount <= maxRedirects) {
          curl2.reset();
          const method = _optionalChain([opts, 'access', _19 => _19.method, 'optionalAccess', _20 => _20.toLocaleUpperCase, 'call', _21 => _21()]) || "GET";
          if (method == "POST") {
            curl2.setopt(constants.CURLOPT.POST, 1);
          } else if (method !== "GET") {
            curl2.setopt(constants.CURLOPT.CUSTOMREQUEST, method);
          }
          if (method == "HEAD") {
            curl2.setopt(constants.CURLOPT.NOBODY, 1);
          }
          curl2.setopt(constants.CURLOPT.URL, currentUrl);
          let body = "";
          let contentType = _optionalChain([opts, 'access', _22 => _22.headers, 'optionalAccess', _23 => _23["Content-Type"]]) || "";
          if (opts.data && typeof opts.data === "object") {
            if (body instanceof URLSearchParams) {
              body = opts.data.toString();
              contentType = "application/x-www-form-urlencoded";
            } else {
              body = JSON.stringify(opts.data);
              contentType = "application/json";
            }
          } else if (typeof opts.data === "string") {
            body = opts.data;
          }
          if (body || ["POST", "PUT", "PATCH"].includes(method)) {
            const data = _buffer.Buffer.from(body);
            curl2.setopt(constants.CURLOPT.POSTFIELDS, data);
            curl2.setopt(constants.CURLOPT.POSTFIELDSIZE, data.length);
            if (method == "GET") {
              curl2.setopt(constants.CURLOPT.CUSTOMREQUEST, method);
            }
          }
          const headers = opts.headers || {};
          if (contentType) {
            headers["Content-Type"] = contentType;
          }
          curl2.setHeaders(headers);
          curl2.setopt(constants.CURLOPT.COOKIEFILE, "");
          curl2.setopt(constants.CURLOPT.COOKIELIST, "ALL");
          if (opts.jar) {
            const cookieJar = opts.jar;
            const cookies = cookieJar.getCookiesSync(currentUrl);
            if (cookies.length > 0) {
              const cookieString = cookies.map((cookie) => `${cookie.key}=${cookie.value}`).join("; ");
              curl2.setopt(constants.CURLOPT.COOKIE, cookieString);
            }
          }
          if (opts.auth) {
            const { username, password } = opts.auth;
            curl2.setopt(constants.CURLOPT.USERNAME, username);
            curl2.setopt(constants.CURLOPT.PASSWORD, password);
          }
          curl2.setopt(constants.CURLOPT.TIMEOUT_MS, (opts.timeout || 0) * 1e3);
          curl2.setopt(constants.CURLOPT.FOLLOWLOCATION, 0);
          if (opts.proxy) {
            const proxy = new URL(opts.proxy);
            curl2.setopt(constants.CURLOPT.PROXY, opts.proxy);
            if (!proxy.protocol.startsWith("socks")) {
              curl2.setopt(constants.CURLOPT.HTTPPROXYTUNNEL, 1);
            }
            if (proxy.username && proxy.password) {
              curl2.setopt(constants.CURLOPT.PROXYUSERNAME, proxy.username);
              curl2.setopt(constants.CURLOPT.PROXYPASSWORD, proxy.password);
            }
          }
          if (opts.verifySsl === false) {
            curl2.setopt(constants.CURLOPT.SSL_VERIFYPEER, 0);
            curl2.setopt(constants.CURLOPT.SSL_VERIFYHOST, 0);
          } else {
            const certPath = getCertPath();
            if (certPath) {
              curl2.setopt(constants.CURLOPT.SSL_VERIFYPEER, 1);
              curl2.setopt(constants.CURLOPT.SSL_VERIFYHOST, 2);
              curl2.setopt(constants.CURLOPT.CAINFO, certPath);
              curl2.setopt(constants.CURLOPT.PROXY_CAINFO, certPath);
              curl2.setopt(constants.CURLOPT.SSLVERSION, constants.CURL_SSLVERSION.DEFAULT);
            }
          }
          if (opts.referer) {
            curl2.setopt(constants.CURLOPT.REFERER, opts.referer);
          }
          if (opts.acceptEncoding) {
            curl2.setopt(constants.CURLOPT.ACCEPT_ENCODING, opts.acceptEncoding);
          }
          if (opts.impersonate) {
            curl2.impersonate(opts.impersonate, true);
          }
          if (opts.ipType) {
            switch (opts.ipType) {
              case "ipv4":
                curl2.setopt(constants.CURLOPT.IPRESOLVE, constants.CURL_IP_RESOLVE.V4);
                break;
              case "ipv6":
                curl2.setopt(constants.CURLOPT.IPRESOLVE, constants.CURL_IP_RESOLVE.V6);
                break;
              case "auto":
                curl2.setopt(constants.CURLOPT.IPRESOLVE, constants.CURL_IP_RESOLVE.WHATEVER);
                break;
            }
          }
          curl2.setopt(constants.CURLOPT.MAX_RECV_SPEED_LARGE, 0);
          const resp = await executeRequest(curl2);
          finalResponseUrl = resp.url || currentUrl;
          if (opts.jar) {
            if (resp.headers.get("set-cookie")) {
              const setCookieHeader = resp.headers.getAll("set-cookie") || [];
              setCookieHeader.forEach((cookie) => {
                try {
                  debug(`\u4ECE\u54CD\u5E94\u5934\u8BBE\u7F6E cookie: ${cookie}`);
                  opts.jar && opts.jar.setCookieSync(cookie, finalResponseUrl);
                } catch (e) {
                  debug("\u4ECE\u54CD\u5E94\u5934\u8BBE\u7F6E cookie \u5931\u8D25:", e);
                }
              });
            }
          }
          const locationHeader = resp.headers.get("location");
          if (opts.followRedirects && resp.status >= 300 && resp.status < 400 && locationHeader && redirectCount < maxRedirects) {
            try {
              currentUrl = new URL(locationHeader, currentUrl).toString();
            } catch (e) {
              currentUrl = locationHeader;
            }
            redirectCount++;
            debug(`\u91CD\u5B9A\u5411\u5230: ${currentUrl} (\u7B2C ${redirectCount} \u6B21)`);
            if (resp.status === 301 || resp.status === 302 || resp.status === 303) {
              if (method === "POST" || method === "PUT" || method === "PATCH") {
                opts.method = "GET";
                opts.data = void 0;
              }
            }
            continue;
          }
          return {
            ...resp,
            url: finalResponseUrl,
            // 使用记录的最终响应URL
            redirectCount
          };
        }
      } catch (error) {
        if (retryAttempt >= maxRetries) {
          throw error;
        }
        debug(`\u8BF7\u6C42\u5931\u8D25\uFF0C\u7B2C ${retryAttempt + 1} \u6B21\u91CD\u8BD5: ${error}`);
      }
    }
  } finally {
    curl2.close();
  }
  throw new Error("\u8BF7\u6C42\u5931\u8D25\uFF0C\u6240\u6709\u91CD\u8BD5\u90FD\u5DF2\u7528\u5B8C");
}
async function get(url, options = {}) {
  return request({ ...options, url, method: "GET" });
}
async function post(url, data, options = {}) {
  return request({ ...options, url, method: "POST", data });
}
async function put(url, data, options = {}) {
  return request({ ...options, url, method: "PUT", data });
}
async function apiDelete(url, options = {}) {
  return request({ ...options, url, method: "DELETE" });
}
async function patch(url, data, options = {}) {
  return request({ ...options, url, method: "PATCH", data });
}
var request_default = { request, get, post, put, delete: apiDelete, patch, Response };

// src/core/websocket.ts
var _events = require('events');
var WsMessageType = /* @__PURE__ */ ((WsMessageType2) => {
  WsMessageType2[WsMessageType2["TEXT"] = 1] = "TEXT";
  WsMessageType2[WsMessageType2["BINARY"] = 2] = "BINARY";
  WsMessageType2[WsMessageType2["CLOSE"] = 8] = "CLOSE";
  WsMessageType2[WsMessageType2["PING"] = 9] = "PING";
  WsMessageType2[WsMessageType2["PONG"] = 10] = "PONG";
  return WsMessageType2;
})(WsMessageType || {});
var WebSocket = class extends _events.EventEmitter {
  constructor(url, options = {}) {
    super();
    this.connected = false;
    this.closing = false;
    this.options = {
      headers: {},
      protocols: [],
      timeout: 3e4,
      pingInterval: 3e4,
      pongTimeout: 5e3
    };
    this.options = { ...this.options, ...options };
    this.curl = new Curl();
    this.setupCurl(url);
  }
  /**
   * 设置CURL选项
   */
  setupCurl(url) {
    const httpUrl = url.replace(/^ws/, "http");
    this.curl.setopt(constants.CURLOPT.URL, httpUrl);
    const headers = [
      "Connection: Upgrade",
      "Upgrade: websocket",
      "Sec-WebSocket-Version: 13",
      "Sec-WebSocket-Key: " + this.generateWebSocketKey(),
      ...Object.entries(this.options.headers).map(([k, v]) => `${k}: ${v}`)
    ];
    if (this.options.protocols.length > 0) {
      headers.push("Sec-WebSocket-Protocol: " + this.options.protocols.join(", "));
    }
    this.curl.setopt(constants.CURLOPT.HTTPHEADER, headers);
    this.curl.setopt(constants.CURLOPT.TIMEOUT, Math.floor(this.options.timeout / 1e3));
    this.curl.setopt(constants.CURLOPT.WRITEFUNCTION, (data) => {
      this.handleWebSocketData(data);
      return data.length;
    });
  }
  /**
   * 生成WebSocket密钥
   */
  generateWebSocketKey() {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    let result = "";
    for (let i = 0; i < 22; i++) {
      result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return result + "==";
  }
  /**
   * 连接WebSocket
   */
  async connect() {
    return new Promise((resolve, reject) => {
      try {
        const resultCode = this.curl.perform();
        if (resultCode !== 0) {
          reject(new Error(`WebSocket\u8FDE\u63A5\u5931\u8D25: ${Curl.strerror(resultCode)}`));
          return;
        }
        const responseCode = this.curl.getinfo(constants.CURLINFO.RESPONSE_CODE);
        if (responseCode === 101) {
          this.connected = true;
          this.startPingInterval();
          this.emit("open");
          resolve();
        } else {
          reject(new Error(`WebSocket\u63E1\u624B\u5931\u8D25\uFF0CHTTP\u72B6\u6001\u7801: ${responseCode}`));
        }
      } catch (error) {
        reject(error);
      }
    });
  }
  /**
   * 发送文本消息
   */
  async sendText(text) {
    const data = Buffer.from(text, "utf8");
    return this.sendFrame(1 /* TEXT */, data);
  }
  /**
   * 发送二进制消息
   */
  async sendBinary(data) {
    return this.sendFrame(2 /* BINARY */, data);
  }
  /**
   * 发送ping
   */
  async ping(data) {
    return this.sendFrame(9 /* PING */, data || Buffer.alloc(0));
  }
  /**
   * 发送pong
   */
  async pong(data) {
    return this.sendFrame(10 /* PONG */, data || Buffer.alloc(0));
  }
  /**
   * 发送WebSocket帧
   */
  async sendFrame(opcode, data) {
    if (!this.connected) {
      throw new Error("WebSocket\u672A\u8FDE\u63A5");
    }
    const frame = this.buildFrame(opcode, data);
    try {
      console.log(`\u53D1\u9001WebSocket\u5E27: opcode=${opcode}, length=${data.length}`);
    } catch (error) {
      this.emit("error", error);
      throw error;
    }
  }
  /**
   * 构建WebSocket帧
   */
  buildFrame(opcode, data) {
    const mask = Buffer.from([
      Math.floor(Math.random() * 256),
      Math.floor(Math.random() * 256),
      Math.floor(Math.random() * 256),
      Math.floor(Math.random() * 256)
    ]);
    let headerLength = 2;
    let payloadLength = data.length;
    if (payloadLength < 126) {
      headerLength += 4;
    } else if (payloadLength < 65536) {
      headerLength += 2 + 4;
    } else {
      headerLength += 8 + 4;
    }
    const frame = Buffer.alloc(headerLength + payloadLength);
    let offset = 0;
    frame[offset++] = 128 | opcode & 15;
    if (payloadLength < 126) {
      frame[offset++] = 128 | payloadLength;
    } else if (payloadLength < 65536) {
      frame[offset++] = 128 | 126;
      frame.writeUInt16BE(payloadLength, offset);
      offset += 2;
    } else {
      frame[offset++] = 128 | 127;
      frame.writeUInt32BE(0, offset);
      frame.writeUInt32BE(payloadLength, offset + 4);
      offset += 8;
    }
    mask.copy(frame, offset);
    offset += 4;
    for (let i = 0; i < payloadLength; i++) {
      frame[offset + i] = data[i] ^ mask[i % 4];
    }
    return frame;
  }
  /**
   * 处理接收到的WebSocket数据
   */
  handleWebSocketData(data) {
    try {
      const message = this.parseFrame(data);
      if (message) {
        this.handleMessage(message);
      }
    } catch (error) {
      this.emit("error", error);
    }
  }
  /**
   * 解析WebSocket帧
   */
  parseFrame(data) {
    if (data.length < 2) return null;
    const firstByte = data[0];
    const secondByte = data[1];
    const fin = (firstByte & 128) === 128;
    const opcode = firstByte & 15;
    const masked = (secondByte & 128) === 128;
    let payloadLength = secondByte & 127;
    let offset = 2;
    if (payloadLength === 126) {
      if (data.length < offset + 2) return null;
      payloadLength = data.readUInt16BE(offset);
      offset += 2;
    } else if (payloadLength === 127) {
      if (data.length < offset + 8) return null;
      payloadLength = data.readUInt32BE(offset + 4);
      offset += 8;
    }
    let mask = null;
    if (masked) {
      if (data.length < offset + 4) return null;
      mask = data.slice(offset, offset + 4);
      offset += 4;
    }
    if (data.length < offset + payloadLength) return null;
    let payload = data.slice(offset, offset + payloadLength);
    if (mask) {
      for (let i = 0; i < payload.length; i++) {
        payload[i] ^= mask[i % 4];
      }
    }
    const message = {
      type: opcode,
      data: payload
    };
    if (opcode === 1 /* TEXT */) {
      message.text = payload.toString("utf8");
    }
    return message;
  }
  /**
   * 处理消息
   */
  handleMessage(message) {
    switch (message.type) {
      case 1 /* TEXT */:
        this.emit("message", message.text, message.type);
        break;
      case 2 /* BINARY */:
        this.emit("message", message.data, message.type);
        break;
      case 9 /* PING */:
        this.pong(message.data);
        this.emit("ping", message.data);
        break;
      case 10 /* PONG */:
        this.handlePong();
        this.emit("pong", message.data);
        break;
      case 8 /* CLOSE */:
        this.handleClose();
        break;
    }
  }
  /**
   * 处理pong响应
   */
  handlePong() {
    if (this.pongTimer) {
      clearTimeout(this.pongTimer);
      this.pongTimer = void 0;
    }
  }
  /**
   * 处理关闭
   */
  handleClose() {
    this.connected = false;
    this.stopPingInterval();
    this.emit("close");
  }
  /**
   * 开始ping间隔
   */
  startPingInterval() {
    this.pingTimer = setInterval(() => {
      if (this.connected && !this.closing) {
        this.ping().catch((err) => this.emit("error", err));
        this.pongTimer = setTimeout(() => {
          this.emit("error", new Error("Pong\u8D85\u65F6"));
          this.close();
        }, this.options.pongTimeout);
      }
    }, this.options.pingInterval);
  }
  /**
   * 停止ping间隔
   */
  stopPingInterval() {
    if (this.pingTimer) {
      clearInterval(this.pingTimer);
      this.pingTimer = void 0;
    }
    if (this.pongTimer) {
      clearTimeout(this.pongTimer);
      this.pongTimer = void 0;
    }
  }
  /**
   * 关闭WebSocket连接
   */
  async close(code = 1e3, reason = "") {
    if (!this.connected || this.closing) return;
    this.closing = true;
    const reasonBuffer = Buffer.from(reason, "utf8");
    const closeData = Buffer.alloc(2 + reasonBuffer.length);
    closeData.writeUInt16BE(code, 0);
    reasonBuffer.copy(closeData, 2);
    try {
      await this.sendFrame(8 /* CLOSE */, closeData);
    } catch (error) {
    }
    this.connected = false;
    this.stopPingInterval();
    this.curl.close();
    this.emit("close");
  }
  /**
   * 获取连接状态
   */
  get readyState() {
    if (this.connected) return 1;
    if (this.closing) return 2;
    return 3;
  }
};

// src/plugs/session.ts
var _axios = require('axios');
var _toughcookie = require('tough-cookie');
var customHttpClient = async (config) => {
  const response = await request_default.request(config);
  return {
    ...response,
    config,
    request: config,
    text: typeof response.data === "string" ? response.data : JSON.stringify(response.data)
  };
};
var CurlSession = class _CurlSession {
  constructor(config) {
    this._config = config || {};
    const axios = this.axios = new (0, _axios.Axios)(config);
    axios.defaults.adapter = customHttpClient;
    if (!config) return;
    this.jar = _nullishCoalesce(_optionalChain([config, 'optionalAccess', _24 => _24.jar]), () => ( new (0, _toughcookie.CookieJar)()));
    this.initHook();
  }
  initHook() {
    this.axios.interceptors.request.use(async (config) => {
      if (this.jar) {
        config.jar = this.jar;
      }
      return config;
    });
    this.axios.interceptors.response.use(
      (response) => {
        return response;
      },
      (error) => {
        return Promise.reject(error);
      }
    );
  }
  clone() {
    return new _CurlSession({
      jar: this.jar,
      ...this._config
    });
  }
  post(url, data, config) {
    return this.axios.post(url, data, config);
  }
  get(url, config) {
    return this.axios.get(url, config);
  }
  request(config) {
    return this.axios.request(config);
  }
  delete(url, config) {
    return this.axios.delete(url, config);
  }
  put(url, data, config) {
    return this.axios.put(url, data, config);
  }
  patch(url, data, config) {
    return this.axios.patch(url, data, config);
  }
  head(url, config) {
    return this.axios.head(url, config);
  }
  options(url, config) {
    return this.axios.options(url, config);
  }
};











exports.Curl = Curl; exports.CurlSession = CurlSession; exports.LogLevel = LogLevel; exports.WebSocket = WebSocket; exports.WsMessageType = WsMessageType; exports.bindingConstants = constants; exports.constants = constants_exports; exports.libcurlVersion = libcurlVersion; exports.logger = logger; exports.req = request_exports;
