// Copyright (C) 2025  Niels Martignène <niels.martignene@protonmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of
// this software and associated documentation files (the “Software”), to deal in
// the Software without restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.

#include <errno.h>

struct ErrnoCodeInfo {
    const char *name;
    int value;
};

const ErrnoCodeInfo ErrnoCodes[] = {
#if defined(E2BIG)
    {"E2BIG", E2BIG },
#endif
#if defined(EACCES)
    {"EACCES", EACCES },
#endif
#if defined(EADDRINUSE)
    {"EADDRINUSE", EADDRINUSE },
#endif
#if defined(EADDRNOTAVAIL)
    {"EADDRNOTAVAIL", EADDRNOTAVAIL },
#endif
#if defined(EADV)
    {"EADV", EADV },
#endif
#if defined(EAFNOSUPPORT)
    {"EAFNOSUPPORT", EAFNOSUPPORT },
#endif
#if defined(EAGAIN)
    {"EAGAIN", EAGAIN },
#endif
#if defined(EALREADY)
    {"EALREADY", EALREADY },
#endif
#if defined(EAUTH)
    {"EAUTH", EAUTH },
#endif
#if defined(EBADE)
    {"EBADE", EBADE },
#endif
#if defined(EBADF)
    {"EBADF", EBADF },
#endif
#if defined(EBADFD)
    {"EBADFD", EBADFD },
#endif
#if defined(EBADMSG)
    {"EBADMSG", EBADMSG },
#endif
#if defined(EBADR)
    {"EBADR", EBADR },
#endif
#if defined(EBADRPC)
    {"EBADRPC", EBADRPC },
#endif
#if defined(EBADRQC)
    {"EBADRQC", EBADRQC },
#endif
#if defined(EBADSLT)
    {"EBADSLT", EBADSLT },
#endif
#if defined(EBFONT)
    {"EBFONT", EBFONT },
#endif
#if defined(EBUSY)
    {"EBUSY", EBUSY },
#endif
#if defined(ECANCELED)
    {"ECANCELED", ECANCELED },
#endif
#if defined(ECAPMODE)
    {"ECAPMODE", ECAPMODE },
#endif
#if defined(ECHILD)
    {"ECHILD", ECHILD },
#endif
#if defined(ECHRNG)
    {"ECHRNG", ECHRNG },
#endif
#if defined(ECOMM)
    {"ECOMM", ECOMM },
#endif
#if defined(ECONNABORTED)
    {"ECONNABORTED", ECONNABORTED },
#endif
#if defined(ECONNREFUSED)
    {"ECONNREFUSED", ECONNREFUSED },
#endif
#if defined(ECONNRESET)
    {"ECONNRESET", ECONNRESET },
#endif
#if defined(EDEADLK)
    {"EDEADLK", EDEADLK },
#endif
#if defined(EDEADLOCK)
    {"EDEADLOCK", EDEADLOCK },
#endif
#if defined(EDESTADDRREQ)
    {"EDESTADDRREQ", EDESTADDRREQ },
#endif
#if defined(EDOM)
    {"EDOM", EDOM },
#endif
#if defined(EDOOFUS)
    {"EDOOFUS", EDOOFUS },
#endif
#if defined(EDOTDOT)
    {"EDOTDOT", EDOTDOT },
#endif
#if defined(EDQUOT)
    {"EDQUOT", EDQUOT },
#endif
#if defined(EEXIST)
    {"EEXIST", EEXIST },
#endif
#if defined(EFAULT)
    {"EFAULT", EFAULT },
#endif
#if defined(EFBIG)
    {"EFBIG", EFBIG },
#endif
#if defined(EFTYPE)
    {"EFTYPE", EFTYPE },
#endif
#if defined(EHOSTDOWN)
    {"EHOSTDOWN", EHOSTDOWN },
#endif
#if defined(EHOSTUNREACH)
    {"EHOSTUNREACH", EHOSTUNREACH },
#endif
#if defined(EHWPOISON)
    {"EHWPOISON", EHWPOISON },
#endif
#if defined(EIDRM)
    {"EIDRM", EIDRM },
#endif
#if defined(EILSEQ)
    {"EILSEQ", EILSEQ },
#endif
#if defined(EINPROGRESS)
    {"EINPROGRESS", EINPROGRESS },
#endif
#if defined(EINTEGRITY)
    {"EINTEGRITY", EINTEGRITY },
#endif
#if defined(EINTR)
    {"EINTR", EINTR },
#endif
#if defined(EINVAL)
    {"EINVAL", EINVAL },
#endif
#if defined(EIO)
    {"EIO", EIO },
#endif
#if defined(EISCONN)
    {"EISCONN", EISCONN },
#endif
#if defined(EISDIR)
    {"EISDIR", EISDIR },
#endif
#if defined(EISNAM)
    {"EISNAM", EISNAM },
#endif
#if defined(EKEYEXPIRED)
    {"EKEYEXPIRED", EKEYEXPIRED },
#endif
#if defined(EKEYREJECTED)
    {"EKEYREJECTED", EKEYREJECTED },
#endif
#if defined(EKEYREVOKED)
    {"EKEYREVOKED", EKEYREVOKED },
#endif
#if defined(EL2HLT)
    {"EL2HLT", EL2HLT },
#endif
#if defined(EL2NSYNC)
    {"EL2NSYNC", EL2NSYNC },
#endif
#if defined(EL3HLT)
    {"EL3HLT", EL3HLT },
#endif
#if defined(EL3RST)
    {"EL3RST", EL3RST },
#endif
#if defined(ELIBACC)
    {"ELIBACC", ELIBACC },
#endif
#if defined(ELIBBAD)
    {"ELIBBAD", ELIBBAD },
#endif
#if defined(ELIBEXEC)
    {"ELIBEXEC", ELIBEXEC },
#endif
#if defined(ELIBMAX)
    {"ELIBMAX", ELIBMAX },
#endif
#if defined(ELIBSCN)
    {"ELIBSCN", ELIBSCN },
#endif
#if defined(ELNRNG)
    {"ELNRNG", ELNRNG },
#endif
#if defined(ELOOP)
    {"ELOOP", ELOOP },
#endif
#if defined(EMEDIUMTYPE)
    {"EMEDIUMTYPE", EMEDIUMTYPE },
#endif
#if defined(EMFILE)
    {"EMFILE", EMFILE },
#endif
#if defined(EMLINK)
    {"EMLINK", EMLINK },
#endif
#if defined(EMSGSIZE)
    {"EMSGSIZE", EMSGSIZE },
#endif
#if defined(EMULTIHOP)
    {"EMULTIHOP", EMULTIHOP },
#endif
#if defined(ENAMETOOLONG)
    {"ENAMETOOLONG", ENAMETOOLONG },
#endif
#if defined(ENAVAIL)
    {"ENAVAIL", ENAVAIL },
#endif
#if defined(ENEEDAUTH)
    {"ENEEDAUTH", ENEEDAUTH },
#endif
#if defined(ENETDOWN)
    {"ENETDOWN", ENETDOWN },
#endif
#if defined(ENETRESET)
    {"ENETRESET", ENETRESET },
#endif
#if defined(ENETUNREACH)
    {"ENETUNREACH", ENETUNREACH },
#endif
#if defined(ENFILE)
    {"ENFILE", ENFILE },
#endif
#if defined(ENOANO)
    {"ENOANO", ENOANO },
#endif
#if defined(ENOATTR)
    {"ENOATTR", ENOATTR },
#endif
#if defined(ENOBUFS)
    {"ENOBUFS", ENOBUFS },
#endif
#if defined(ENOCSI)
    {"ENOCSI", ENOCSI },
#endif
#if defined(ENODATA)
    {"ENODATA", ENODATA },
#endif
#if defined(ENODEV)
    {"ENODEV", ENODEV },
#endif
#if defined(ENOENT)
    {"ENOENT", ENOENT },
#endif
#if defined(ENOEXEC)
    {"ENOEXEC", ENOEXEC },
#endif
#if defined(ENOKEY)
    {"ENOKEY", ENOKEY },
#endif
#if defined(ENOLCK)
    {"ENOLCK", ENOLCK },
#endif
#if defined(ENOLINK)
    {"ENOLINK", ENOLINK },
#endif
#if defined(ENOMEDIUM)
    {"ENOMEDIUM", ENOMEDIUM },
#endif
#if defined(ENOMEM)
    {"ENOMEM", ENOMEM },
#endif
#if defined(ENOMSG)
    {"ENOMSG", ENOMSG },
#endif
#if defined(ENONET)
    {"ENONET", ENONET },
#endif
#if defined(ENOPKG)
    {"ENOPKG", ENOPKG },
#endif
#if defined(ENOPROTOOPT)
    {"ENOPROTOOPT", ENOPROTOOPT },
#endif
#if defined(ENOSPC)
    {"ENOSPC", ENOSPC },
#endif
#if defined(ENOSR)
    {"ENOSR", ENOSR },
#endif
#if defined(ENOSTR)
    {"ENOSTR", ENOSTR },
#endif
#if defined(ENOSYS)
    {"ENOSYS", ENOSYS },
#endif
#if defined(ENOTBLK)
    {"ENOTBLK", ENOTBLK },
#endif
#if defined(ENOTCAPABLE)
    {"ENOTCAPABLE", ENOTCAPABLE },
#endif
#if defined(ENOTCONN)
    {"ENOTCONN", ENOTCONN },
#endif
#if defined(ENOTDIR)
    {"ENOTDIR", ENOTDIR },
#endif
#if defined(ENOTEMPTY)
    {"ENOTEMPTY", ENOTEMPTY },
#endif
#if defined(ENOTNAM)
    {"ENOTNAM", ENOTNAM },
#endif
#if defined(ENOTRECOVERABLE)
    {"ENOTRECOVERABLE", ENOTRECOVERABLE },
#endif
#if defined(ENOTSOCK)
    {"ENOTSOCK", ENOTSOCK },
#endif
#if defined(ENOTSUP)
    {"ENOTSUP", ENOTSUP },
#endif
#if defined(ENOTTY)
    {"ENOTTY", ENOTTY },
#endif
#if defined(ENOTUNIQ)
    {"ENOTUNIQ", ENOTUNIQ },
#endif
#if defined(ENXIO)
    {"ENXIO", ENXIO },
#endif
#if defined(EOPNOTSUPP)
    {"EOPNOTSUPP", EOPNOTSUPP },
#endif
#if defined(EOTHER)
    {"EOTHER", EOTHER },
#endif
#if defined(EOVERFLOW)
    {"EOVERFLOW", EOVERFLOW },
#endif
#if defined(EOWNERDEAD)
    {"EOWNERDEAD", EOWNERDEAD },
#endif
#if defined(EPERM)
    {"EPERM", EPERM },
#endif
#if defined(EPFNOSUPPORT)
    {"EPFNOSUPPORT", EPFNOSUPPORT },
#endif
#if defined(EPIPE)
    {"EPIPE", EPIPE },
#endif
#if defined(EPROCLIM)
    {"EPROCLIM", EPROCLIM },
#endif
#if defined(EPROCUNAVAIL)
    {"EPROCUNAVAIL", EPROCUNAVAIL },
#endif
#if defined(EPROGMISMATCH)
    {"EPROGMISMATCH", EPROGMISMATCH },
#endif
#if defined(EPROGUNAVAIL)
    {"EPROGUNAVAIL", EPROGUNAVAIL },
#endif
#if defined(EPROTO)
    {"EPROTO", EPROTO },
#endif
#if defined(EPROTONOSUPPORT)
    {"EPROTONOSUPPORT", EPROTONOSUPPORT },
#endif
#if defined(EPROTOTYPE)
    {"EPROTOTYPE", EPROTOTYPE },
#endif
#if defined(ERANGE)
    {"ERANGE", ERANGE },
#endif
#if defined(EREMCHG)
    {"EREMCHG", EREMCHG },
#endif
#if defined(EREMOTE)
    {"EREMOTE", EREMOTE },
#endif
#if defined(EREMOTEIO)
    {"EREMOTEIO", EREMOTEIO },
#endif
#if defined(ERESTART)
    {"ERESTART", ERESTART },
#endif
#if defined(ERFKILL)
    {"ERFKILL", ERFKILL },
#endif
#if defined(EROFS)
    {"EROFS", EROFS },
#endif
#if defined(ERPCMISMATCH)
    {"ERPCMISMATCH", ERPCMISMATCH },
#endif
#if defined(ESHUTDOWN)
    {"ESHUTDOWN", ESHUTDOWN },
#endif
#if defined(ESOCKTNOSUPPORT)
    {"ESOCKTNOSUPPORT", ESOCKTNOSUPPORT },
#endif
#if defined(ESPIPE)
    {"ESPIPE", ESPIPE },
#endif
#if defined(ESRCH)
    {"ESRCH", ESRCH },
#endif
#if defined(ESRMNT)
    {"ESRMNT", ESRMNT },
#endif
#if defined(ESTALE)
    {"ESTALE", ESTALE },
#endif
#if defined(ESTRPIPE)
    {"ESTRPIPE", ESTRPIPE },
#endif
#if defined(ETIME)
    {"ETIME", ETIME },
#endif
#if defined(ETIMEDOUT)
    {"ETIMEDOUT", ETIMEDOUT },
#endif
#if defined(ETOOMANYREFS)
    {"ETOOMANYREFS", ETOOMANYREFS },
#endif
#if defined(ETXTBSY)
    {"ETXTBSY", ETXTBSY },
#endif
#if defined(EUCLEAN)
    {"EUCLEAN", EUCLEAN },
#endif
#if defined(EUNATCH)
    {"EUNATCH", EUNATCH },
#endif
#if defined(EUSERS)
    {"EUSERS", EUSERS },
#endif
#if defined(EWOULDBLOCK)
    {"EWOULDBLOCK", EWOULDBLOCK },
#endif
#if defined(EXDEV)
    {"EXDEV", EXDEV },
#endif
#if defined(EXFULL)
    {"EXFULL", EXFULL },
#endif
#if defined(STRUNCATE)
    {"STRUNCATE", STRUNCATE },
#endif
};
