import { IFunCaptchaTask, IHCaptchaTask, IRecaptchaMobileTask, IReCaptchaV2Task, IReCaptchaV3Task } from "./interface";
export default class NextCaptcha {
    private api;
    constructor(apiKey: string);
    waitForResult(taskId: string, tryTimes?: number): Promise<any>;
    recaptchaV2({ websiteURL, websiteKey, recaptchaDataSValue, isInvisible, apiDomain, proxyType, proxyAddress, proxyPort, proxyLogin, proxyPassword }: IReCaptchaV2Task): Promise<any>;
    recaptchaV2Enterprise({ websiteURL, websiteKey, enterprisePayload, pageAction, isInvisible, apiDomain, proxyType, proxyAddress, proxyPort, proxyLogin, proxyPassword }: IReCaptchaV2Task): Promise<any>;
    recaptchaV3({ websiteURL, websiteKey, pageAction, proxyType, proxyAddress, proxyPort, proxyLogin, proxyPassword }: IReCaptchaV3Task): Promise<any>;
    recaptchaMobile({ appPackageName, appKey, appAction, appDevice }: IRecaptchaMobileTask): Promise<any>;
    hcaptcha({ websiteURL, websiteKey, enterprisePayload, isInvisible, proxyType, proxyAddress, proxyPort, proxyLogin, proxyPassword }: IHCaptchaTask): Promise<any>;
    hcaptchaEnterprise({ websiteURL, websiteKey, enterprisePayload, isInvisible, proxyType, proxyAddress, proxyPort, proxyLogin, proxyPassword }: IHCaptchaTask): Promise<any>;
    funcaptcha({ websitePublicKey, websiteURL, data, proxyType, proxyAddress, proxyPort, proxyLogin, proxyPassword }: IFunCaptchaTask): Promise<any>;
    getBalance(): Promise<number>;
}
//# sourceMappingURL=index.d.ts.map