"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const globals_1 = require("@jest/globals");
const src_1 = __importDefault(require("../src"));
require('dotenv').config();
const clientKey = process.env.CLIENT_KEY || '';
const client = new src_1.default(clientKey);
(0, globals_1.describe)('client', () => {
    (0, globals_1.test)('getBalance', async () => {
        const balance = await client.getBalance();
        (0, globals_1.expect)(typeof balance).toBe('number');
    }, 30000);
    (0, globals_1.test)('recaptchaV2Proxyless', async () => {
        var _a;
        const result = await client.recaptchaV2({
            websiteKey: '6Le-wvkSAAAAAPBMRTvw0Q4Muexq9bi0DJwx_mJ-',
            websiteURL: 'https://www.google.com/recaptcha/api2/demo'
        });
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.errorId).toEqual(0);
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.status).toEqual('ready');
        (0, globals_1.expect)(typeof ((_a = result === null || result === void 0 ? void 0 : result.solution) === null || _a === void 0 ? void 0 : _a.gRecaptchaResponse)).toEqual('string');
    });
    (0, globals_1.test)('recaptchaV2Enterprise', async () => {
        var _a;
        const result = await client.recaptchaV2Enterprise({
            websiteKey: '6LddGoYgAAAAAHD275rVBjuOYXiofr1u4pFS5lHn',
            websiteURL: 'https://onlyfans.com',
            isInvisible: false,
            pageAction: 'register'
        });
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.errorId).toEqual(0);
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.status).toEqual('ready');
        (0, globals_1.expect)(typeof ((_a = result === null || result === void 0 ? void 0 : result.solution) === null || _a === void 0 ? void 0 : _a.gRecaptchaResponse)).toEqual('string');
    });
    (0, globals_1.test)('recaptchaV3Proxyless', async () => {
        var _a;
        const result = await client.recaptchaV3({
            websiteKey: '6LdKlZEpAAAAAAOQjzC2v_d36tWxCl6dWsozdSy9',
            websiteURL: 'https://recaptcha-demo.appspot.com/recaptcha-v3-request-scores.php',
            pageAction: 'examples/v3scores'
        });
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.errorId).toEqual(0);
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.status).toEqual('ready');
        (0, globals_1.expect)(typeof ((_a = result === null || result === void 0 ? void 0 : result.solution) === null || _a === void 0 ? void 0 : _a.gRecaptchaResponse)).toEqual('string');
    });
    (0, globals_1.test)('recaptchaMobile', async () => {
        var _a;
        const result = await client.recaptchaMobile({
            "appPackageName": "com.reddit.frontpage",
            "appKey": "6LdyAhomAAAAAGFyldGQ2cRYneZZS-5FnEG_xjwb",
            "appAction": "login_with_password",
            "appDevice": "Android"
        });
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.errorId).toEqual(0);
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.status).toEqual('ready');
        (0, globals_1.expect)(typeof ((_a = result === null || result === void 0 ? void 0 : result.solution) === null || _a === void 0 ? void 0 : _a.gRecaptchaResponse)).toEqual('string');
    });
    (0, globals_1.test)('hcaptcha', async () => {
        var _a;
        const result = await client.hcaptcha({
            "websiteURL": "https://discord.com",
            "websiteKey": "4c672d35-0701-42b2-88c3-78380b0db560",
        });
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.errorId).toEqual(0);
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.status).toEqual('ready');
        (0, globals_1.expect)(typeof ((_a = result === null || result === void 0 ? void 0 : result.solution) === null || _a === void 0 ? void 0 : _a.gRecaptchaResponse)).toEqual('string');
    });
    (0, globals_1.test)('funcaptcha', async () => {
        var _a;
        const result = await client.funcaptcha({
            "websiteURL": "https://iframe.arkoselabs.com/7D857050-F609-4F6A-AF63-CD04DE665FFE/index.html?mkt=en",
            "websitePublicKey": "7D857050-F609-4F6A-AF63-CD04DE665FFE",
        });
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.errorId).toEqual(0);
        (0, globals_1.expect)(result === null || result === void 0 ? void 0 : result.status).toEqual('ready');
        (0, globals_1.expect)(typeof ((_a = result === null || result === void 0 ? void 0 : result.solution) === null || _a === void 0 ? void 0 : _a.token)).toEqual('string');
    });
});
