const express = require('express');
const app = express();
const port = 3000;
const checker = require('./checkers/fu-00auth-ventra.js');

app.use(express.json());

app.get('/check', async (req, res) => {
    const cc = req.query.cc;
    if (!cc) {
        return res.status(400).json({ error: 'Missing cc parameter' });
    }
    try {
        const result = await checker(cc);
        res.json(result);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
});

app.listen(port, () => {
    console.log(`Server running at http://localhost:${port}`);
});
