const axios = require('axios')
const aka = require('agentkeepalive')
const tough = require("tough-cookie")
const Caseless = require('caseless')
const UserAgents = require('user-agents')
const { randomIp } = require('./randomIp')

const agentOptions = {
    maxSockets: 100,
    maxFreeSockets: 50,
    timeout: 60000,
    freeSocketTimeout: 30000,
}

const httpAgent = new aka(agentOptions)
const httpsAgent = new aka.HttpsAgent(agentOptions)

async function request(options) {
    if (options.proxy) {
        let proxy = typeof options.proxy == "function" ? options.proxy() : options.proxy
        let { protocol, hostname, username, password, port } = new URL(proxy)
        options.proxy = {
            protocol,
            hostname,
            port: parseInt(port)
        }
        if (username || password) options.proxy.auth = {
            username, password
        }
    }

    let headers = {}
    if (options.headers) {
        for (let header of Object.keys(options.headers).filter(Boolean)) {
            if (header.toLowerCase() == 'cookie') {
                if (options.jar) {
                    let cookiesInJar = options.jar.getCookieStringSync(options.url)
                    if (!cookiesInJar) {
                        Object.assign(headers, { [header]: options.headers[header] })
                    } else {
                        Object.assign(headers, { [header]: `${options.headers[header]}; ${cookiesInJar}` })
                    }
                } else {
                    Object.assign(headers, { [header]: options.headers[header] })
                }
            } else {
                Object.assign(headers, { [header]: options.headers[header] })
            }
        }
    }

    let caseless = Caseless(headers)
    if (!caseless.has('cookie') && options.jar) {
        let cookiesInJar = options.jar.getCookieStringSync(options.url)
        if (cookiesInJar) Object.assign(headers, { cookie: cookiesInJar })
    }

    if (options.forever) {
        let { protocol } = new URL(options.url)
        if (protocol == 'http:') {
            options.agent = httpAgent
        } else if (protocol == 'https:') {
            options.agent = httpsAgent
        }
    }

    if (options.xff) {
        caseless.set('x-real-ip', randomIp())
        caseless.set('x-forwarded-for', `${randomIp()}, ${randomIp()}, ${randomIp()}`)
        caseless.set('true-client-ip', randomIp())
    }

    if (!caseless.has('user-agent')) {
        let userAgent = new UserAgents({ deviceCategory: options.desktop ? 'desktop' : 'mobile' })
        caseless.set('user-agent', userAgent.toString())
    }

    options.headers = headers
    options.maxBodyLength = Infinity
    var response = await axios(options).then((response) => response).catch((error) => error.response)

    if (options.jar) {
        let { protocol, host } = new URL(options.url)
        let hostname = `${protocol}//${host}/`
        let caseless = Caseless(response.headers)
        if (caseless.has('set-cookie')) {
            caseless.get('set-cookie').forEach(function (line) {
                let cookie = line.split(';')[0]
                options.jar.setCookieSync(cookie, hostname)
            })
        }
    }

    return response
}

request.jar = function () {
    return new tough.CookieJar()
}

module.exports = request