const FS = require("fs-extra")
const PATH = require("path")
const binList = FS.readFileSync(PATH.join(__dirname, 'binList.csv')).toString()

module.exports = card => {
	if (!card || card.length < 6) return ''
	var bin = card.substr(0, 6)

	var found = binList.match(new RegExp(`${bin}.*?\n`, 'gmsi'))
	if (!found) return false

	var data = found[0].split(';')

	if (data[0] == bin) {
		var bin = data[0]
		var brand = data[1]
		var issuer = data[2]
		var type = data[3]
		var category = data[4]
		var country = data[5]
		var country_code = data[6]
		var str = `${brand} ${issuer} ${type} ${category} ${country}`
		return str.replace(/  +/g, ' ').replace(/\n|\r/g, '')
	} else {
		return false
	}
}