const curlyoshi = require("./curlyoshi")

class CapMonster {
    constructor(clientKey = '') {
        this.clientKey = clientKey
    }

    async decodeReCaptchaV2(websiteURL = '', websiteKey = '') {
        if (typeof this.clientKey !== 'string' || !this.clientKey.length)
            throw new Error('No clientKey provided or clientKey not String')
        let solved = false
        const json = await curlyoshi({
            method: 'POST',
            url: `https://api.capmonster.cloud/createTask`,
            json: {
                clientKey: this.clientKey,
                task: {
                    type: 'NoCaptchaTaskProxyless',
                    websiteURL: websiteURL,
                    websiteKey: websiteKey,
                },
            },
            proxy: process.env.PROXY
        }).then(res => res?.body)

        while (!solved) {
            await new Promise((resolve) => setTimeout(resolve, 2000))
            const result = await this.getResult(json.taskId)
            if (result.status == 'ready') {
                solved = true
                return result
            }
        }
    }

    async getResult(taskId = 0) {
        if (typeof this.clientKey !== 'string' || !this.clientKey.length)
            throw new Error('No clientKey provided or clientKey not String')
        const json = await curlyoshi({
            method: 'POST',
            url: 'https://api.capmonster.cloud/getTaskResult',
            json: {
                clientKey: this.clientKey,
                taskId: taskId
            },
            proxy: process.env.PROXY
        }).then(res => res?.body)

        return json
    }
}

module.exports = CapMonster
