const luhnCheck = require("./luhnCheck")
module.exports = (card, track = false) => {
	try {
		const cardValues = card.replace(/\D|=/g, "|").split("|").filter(Boolean)
		const cardIndex = cardValues.indexOf(cardValues.filter(values => luhnCheck(values)).find(Boolean))
		if (cardIndex == -1) return [false]
		const parsedCard = cardValues.slice(cardIndex)
		if (parsedCard[1].length >= 4) {
			if (track) {
				parsedCard.push(parsedCard[1].substr(4))
			}
			parsedCard[3] = parsedCard[2]
			parsedCard[2] = parsedCard[1].slice(0, 2)
			parsedCard[1] = parsedCard[1].slice(2, 4)
		}
		return [true, ...parsedCard]
	} catch (error) {
		return [false]
	}
}