const isValidCPF = require("./isValidCPF")

module.exports = async row => {
	const entries = row.split(/[|:; ]/g).filter(Boolean)
	const trash = row.split("").map((_, i) => row.replace(/[.-]/g, "").slice(i, i + 11))
	const cpf = trash.find(entry => isValidCPF(entry.replace(/\D/g, "")))
	if (typeof cpf == "undefined") return [false]
	const rest = entries.slice(entries.findIndex(entry => entry.replace(/\D/g, "").includes(cpf)) + 1)

	return [true, cpf, ...rest]
}