const isValidEmail = require("./isValidEmail")

// Check if the entry is a valid username (alphanumeric, underscores, and no special characters)
const isValidUsername = entry => /^[a-zA-Z0-9_]+$/.test(entry);

module.exports = async row => {
    // Split the row using the specified delimiters and filter out empty entries
    const entries = row.split(/[|:; ]/g).filter(Boolean);

    // Look for a valid email or username
    const emailOrUsername = entries.find(entry => isValidEmail(entry) || isValidUsername(entry));

    // If neither an email nor a username is found, return [false]
    if (typeof emailOrUsername === "undefined") return [false];

    // Extract the rest of the entries after the found email/username
    const rest = entries.slice(entries.findIndex(entry => entry.replace(/[#$%&'+\/=?]/g, "").includes(emailOrUsername)) + 1);

    return [true, emailOrUsername, ...rest];
};
