const CliColor = require("cli-color")

module.exports = class {
    constructor(options = {}) {
        this.options = options
        if (!options) {
            this.options = {
                success: { badge: '■', label: 'success' },
                error: { badge: '■', label: 'error' },
                warning: { badge: '■', label: 'warning' },
                info: { badge: '■', label: 'info' }
            }
        }
        this.maxLenght = Math.max(...(Object.keys(this.options).map((i) => this.options[i].label.length)))
    }

    success(message) {
        return CliColor.green(this.options.success.badge + '  ' + CliColor.underline(this.options.success.label) + new Array(this.maxLenght - this.options.success.label.length + 3).join(' ') + message)
    }
    error(message) {
        return CliColor.red(this.options.error.badge + '  ' + CliColor.underline(this.options.error.label) + new Array(this.maxLenght - this.options.error.label.length + 3).join(' ') + message)
    }
    warning(message) {
        return CliColor.yellow(this.options.warning.badge + '  ' + CliColor.underline(this.options.warning.label) + new Array(this.maxLenght - this.options.warning.label.length + 3).join(' ') + message)
    }
    info(message) {
        return CliColor.cyan(this.options.info.badge + '  ' + CliColor.underline(this.options.info.label) + new Array(this.maxLenght - this.options.info.label.length + 3).join(' ') + message)
    }
}