const curlyoshi = require("./curlyoshi")

class TwoCaptcha {
    constructor(clientKey = '', proxy = false) {
        this.clientKey = clientKey
        this.proxy = false
        if (proxy) {
            this.proxy = proxy
        }
    }

    async decodeReCaptchaV2(websiteURL = '', websiteKey = '') {
        if (typeof this.clientKey !== 'string' || !this.clientKey.length)
            throw new Error('No clientKey provided or clientKey not String')
        let solved = false
        const json = await curlyoshi({
            method: 'GET',
            url: `https://2captcha.com/in.php?method=userrecaptcha&json=1&key=${this.clientKey}&googlekey=${websiteKey}&pageurl=${websiteURL}`,
            json: true,
            proxy: this.proxy
        }).then(res => res?.body)

        if (json?.error_text) return { error: json?.error_text }
        if (json?.status == 0) return { error: json?.request }

        while (!solved) {
            await new Promise((resolve) => setTimeout(resolve, 2000))
            const result = await this.getResult(json?.request)
            if (json?.error_text) return { error: json?.error_text }
            if (json?.status == 0 && json?.request !== 'CAPCHA_NOT_READY') return { error: json?.request }
            if (result?.status == 1) {
                solved = true
                return result
            }
        }
    }

    async getResult(taskId = 0) {
        if (typeof this.clientKey !== 'string' || !this.clientKey.length)
            throw new Error('No clientKey provided or clientKey not String')
        const json = await curlyoshi({
            method: 'GET',
            url: `https://2captcha.com/res.php?action=get&json=1&key=${this.clientKey}&id=${taskId}`,
            json: true,
            proxy: this.proxy
        }).then(res => res?.body)

        return json
    }
}

module.exports = TwoCaptcha