const PRODUCT_ARRAY = [
  [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
  [0, 2, 4, 6, 8, 1, 3, 5, 7, 9]
];

function ccMod10Check(value) {
  if (value) {
    value = value.toString().replace(/\s+/g, '');
    let l = value.length;
    let multiple = 0;
    let sum = 0;

    while (l--) {
      sum += PRODUCT_ARRAY[multiple][parseInt(value.charAt(l), 10)];
      multiple ^= 1;
    }

    return sum > 0 && sum % 10 === 0;
  }

  return true;
};

function ccMod11Check(value) {
  if (value) {
    value = value.toString();
    const strippedValue = value.replace(/\D/g, ''); // numbers only
    const len = strippedValue.length; // usually 16
    const digit = strippedValue[len - 1]; // tester digit
    const testDigits = strippedValue.substr(0, len - 1); // 15 digits (drops the last value)
    let i;
    let myCheck;
    let total = 0;
    let temp;

    for (i = len - 1; i > 0;) {
      temp = +testDigits[--i];
      if (i % 2 == 0) {
        temp *= 2;
      }

      if (temp > 9) {
        temp -= 9;
      }

      total += temp;
    }

    myCheck = (10 - (total % 10)) % 10;
    myCheck = (myCheck + 1) % 10;

    if (myCheck == +digit) {
      return true;
    }
    return false;
  }

  return true;
};

module.exports = (value, checkMod11) => {
  const mod10 = true;
  const mod11 = checkMod11;
  const isMod10 = ccMod10Check(value);
  let isMod11 = false;

  if (mod11) {
    isMod11 = ccMod11Check(value);
  }

  return mod10 && mod11
    ? // either
    isMod10 || isMod11
    : // specific
    mod10
      ? isMod10
      : isMod11;
};

